<!DOCTYPE html>
<html lang="en">
<head>
	
	<meta charset="UTF-8">
	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta http-equiv="X-UA-Compatible" content="IE=9" />
	
	<!-- Title -->
	<title>الأخبار</title>
	
	<!-- Favicon -->
	<link rel="icon" href="<?php echo e(asset('public/assets/img/brand/favicon.png')); ?>" type="image/x-icon"/>
	
	<!-- Icons css -->
	<link href="<?php echo e(asset('public/assets/css/icons.css')); ?>" rel="stylesheet">
	
	<!-- Bootstrap css -->
	<link href="<?php echo e(asset('public/assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
	
	<!--  Owl-carousel css-->
	<link href="<?php echo e(asset('public/assets/plugins/owl-carousel/owl.carousel.css')); ?>" rel="stylesheet" />
	
	<!-- P-scroll bar css-->
	<link href="<?php echo e(asset('public/assets/plugins/perfect-scrollbar/p-scrollbar.css')); ?>" rel="stylesheet" />
	
	<!--  Right-sidemenu css -->
	<link href="<?php echo e(asset('public/assets/plugins/sidebar/sidebar.css')); ?>" rel="stylesheet">
	
	<!-- Sidemenu css -->
	<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/sidemenu.css')); ?>">
	
	<!-- Maps css -->
	<link href="<?php echo e(asset('public/assets/plugins/jqvmap/jqvmap.min.css')); ?>" rel="stylesheet">
	
	<!-- style css -->
	<link href="<?php echo e(asset('public/assets/css/style.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/assets/css/style-dark.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/assets/css/boxed.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('public/assets/css/dark-boxed.css')); ?>" rel="stylesheet">
	
	<!---Skinmodes css-->
	<link href="<?php echo e(asset('public/assets/css/skin-modes.css')); ?>" rel="stylesheet" />
	
	<!-- Cdn Font awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	
	<!-- Datatable css -->
	<link href="//cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
	
	<!-- CSRF Token -->
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	
</head>

<body class="main-body app sidebar-mini">
	
	<!-- Loader -->
	<div id="global-loader">
		<img src="<?php echo e(asset('public/assets/img/loader.svg')); ?>"  class="loader-img" alt="Loader">
	</div>
	<!-- /Loader -->
	
	<!-- Page -->
	<div class="page">
		
		<!-- main-sidebar -->
		<div class="app-sidebar__overlay" data-bs-toggle="sidebar"></div>
		<aside class="app-sidebar sidebar-scroll">
			<div class="main-sidebar-header active">
				<a class="desktop-logo logo-light active" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/logo.png')); ?>" class="main-logo" alt="logo"></a>
				<a class="desktop-logo logo-dark active" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/logo-white.png')); ?>" class="main-logo dark-theme" alt="logo"></a>
				<a class="logo-icon mobile-logo icon-light active" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/favicon.png')); ?>" class="logo-icon" alt="logo"></a>
				<a class="logo-icon mobile-logo icon-dark active" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/favicon-white.png')); ?>" class="logo-icon dark-theme" alt="logo"></a>
			</div>
			<div class="main-sidemenu">
				<ul class="side-menu">
					<li class="side-item side-item-category"><?php echo trans('layout.main'); ?></li>
					<li class="slide">
						<a class="side-menu__item" href="<?php echo e(route('home')); ?>">
							<i class="fa-solid fa-house side-menu__icon"></i>
							<span class="side-menu__label"><?php echo trans('layout.home'); ?></span>
						</a>
					</li>
					<li class="slide">
						<a class="side-menu__item" href="<?php echo e(route('news')); ?>">
							<i class="fa-solid fa-newspaper side-menu__icon"></i>
							<span class="side-menu__label"><?php echo trans('layout.news'); ?></span>
						</a>
					</li>
					<li class="slide">
						<a class="side-menu__item" href="<?php echo e(route('categories')); ?>">
							<i class="fa-solid fa-folder-open side-menu__icon"></i>
							<span class="side-menu__label"><?php echo trans('layout.categories'); ?></span>
						</a>
					</li>
				</ul>
			</div>
		</aside>
		<!-- main-sidebar -->
		
		<!-- main-content -->
		<div class="main-content app-content">
			
			<!-- main-header -->
			<div class="main-header sticky side-header nav nav-item">
				<div class="container-fluid">
					<div class="main-header-left ">
						<div class="responsive-logo">
							<a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/logo.png')); ?>" class="logo-1" alt="logo"></a>
							<a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/logo-white.png')); ?>" class="dark-logo-1" alt="logo"></a>
							<a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/favicon.png')); ?>" class="logo-2" alt="logo"></a>
							<a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('public/assets/img/brand/favicon-white.png')); ?>" class="dark-logo-2" alt="logo"></a>
						</div>
						<div class="app-sidebar__toggle" data-bs-toggle="sidebar">
							<a class="open-toggle" href="#">
								<i class="header-icon fe fe-align-left"></i>
							</a>
							<a class="close-toggle" href="#">
								<i class="header-icons fe fe-x"></i>
							</a>
						</div>
					</div>
					<div class="main-header-right">
						<ul class="nav nav-item  navbar-nav-right ms-auto">											
							<li class="nav-link" id="bs-example-navbar-collapse-1">
								<form class="navbar-form" role="search">
									<div class="input-group">
										<input type="text" class="form-control" placeholder="Search">
										<span class="input-group-btn">
											<button type="reset" class="btn btn-default">
												<i class="fas fa-times"></i>
											</button>
										</span>
									</div>
								</form>
							</li>
							<li class="nav">
								<div class="dropdown nav-itemd-none d-md-flex">
									<a href="#" class="d-flex  nav-item country-flag1" data-bs-toggle="dropdown" aria-expanded="false">
										<span class="avatar country-Flag me-0 align-self-center bg-transparent">
											<!-- If auth language is Arabic in database -->
											<?php if(Auth::user()->language == 'ar'): ?>
											<img src="<?php echo e(asset('public/assets/img/flags/ara.png')); ?>" alt="img">
											<?php else: ?>
											<img src="<?php echo e(asset('public/assets/img/flags/fr.png')); ?>" alt="img">
											<?php endif; ?>
										</span>
										<div class="my-auto">
											<strong class="me-2 ms-2 my-auto"><?php echo trans('layout.language'); ?></strong>
										</div>
									</a>
									<div class="dropdown-menu dropdown-menu-arrow" x-placement="bottom-end" style="transform: translate(0px, 59px) !important">
										<a href="#" class="dropdown-item d-flex " onclick="changeLanguage('<?php echo e(Auth::user()->language); ?>')">
											<span class="avatar  me-3 align-self-center bg-transparent">
												<?php if(Auth::user()->language == 'ar'): ?>
												<img src="<?php echo e(asset('public/assets/img/flags/fr.png')); ?>" alt="img">
												<?php else: ?>
												<img src="<?php echo e(asset('public/assets/img/flags/ara.png')); ?>" alt="img">
												<?php endif; ?>
											</span>
											<div class="d-flex">
												<?php if(Auth::user()->language == 'ar'): ?>
												<span class="mt-2"><?php echo trans('layout.french'); ?></span>
												<?php else: ?>
												<span class="mt-2"><?php echo trans('layout.arabic'); ?></span>
												<?php endif; ?>
											</div>
										</a>
									</div>
								</div>
							</li>
							<li class="dropdown main-profile-menu nav nav-item nav-link">
								
								<a class="profile-user d-flex" href="">
									<img alt="" src="<?php echo e(asset('public/assets/img/faces/user.png')); ?>">
								</a>
								<div class="dropdown-menu">
									<div class="main-header-profile bg-alkhbar p-3">
										<div class="d-flex wd-100p">
											<div class="main-img-user">
												<img alt="" src="<?php echo e(asset('public/assets/img/faces/user.png')); ?>" class="">
											</div>
											<div class="ms-3 my-auto">
												<h6 id="user_name"></h6>
											</div>
										</div>
									</div>
									<a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
										<i class="bx bx-user-circle"></i><?php echo trans('layout.profile'); ?></a>
										<a class="dropdown-item" href="#" onclick="LogoutUser()">
											<i class="bx bx-log-out"></i>
											<?php echo trans('layout.sign_out'); ?>

										</a>
									</div>
								</li>
							</ul>
						</div>
					</div>
				</div>
				<!-- /main-header -->
				<!-- main-content opened -->
				<?php echo $__env->yieldContent('content'); ?>
				<!-- Container closed -->
				
			</div>
			<!-- /main-content -->
			
			<!-- Footer opened -->
			<div class="main-footer ht-40">
				<div class="container-fluid pd-t-0-f ht-100p">
					<span>Copyright © 2022 All rights reserved.</span>
				</div>
			</div>
			<!-- Footer closed -->
			
		</div>
		<!-- End Page -->
		
		<!-- Back-to-top -->
		<a href="#top" id="back-to-top"><i class="las la-angle-double-up"></i></a>
		
		<!-- Language js -->
		<script src="<?php echo e(asset('public/script/language.js')); ?>"></script>
		
		<!-- JQuery min js -->
		<script src="<?php echo e(asset('public/assets/plugins/jquery/jquery.min.js')); ?>"></script>
		
		<!-- Bootstrap Bundle js -->
		<script src="<?php echo e(asset('public/assets/plugins/bootstrap/js/popper.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
		
		<!--Internal  Chart.bundle js -->
		<script src="<?php echo e(asset('public/assets/plugins/chart.js/Chart.bundle.min.js')); ?>"></script>
		
		<!-- Ionicons js -->
		<script src="<?php echo e(asset('public/assets/plugins/ionicons/ionicons.js')); ?>"></script>
		
		<!-- Moment js -->
		<script src="<?php echo e(asset('public/assets/plugins/moment/moment.js')); ?>"></script>
		
		<!--Internal Sparkline js -->
		<script src="<?php echo e(asset('public/assets/plugins/jquery-sparkline/jquery.sparkline.min.js')); ?>"></script>
		
		<!-- Moment js -->
		<script src="<?php echo e(asset('public/assets/plugins/raphael/raphael.min.js')); ?>"></script>
		
		<!--Internal Apexchart js-->
		<script src="<?php echo e(asset('public/assets/js/apexcharts.js')); ?>"></script>
		
		<!-- Rating js-->
		<script src="<?php echo e(asset('public/assets/plugins/rating/jquery.rating-stars.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/plugins/rating/jquery.barrating.js')); ?>"></script>
		
		<!--Internal  Perfect-scrollbar js -->
		<script src="<?php echo e(asset('public/assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/plugins/perfect-scrollbar/p-scroll.js')); ?>"></script>
		
		<!-- Eva-icons js -->
		<script src="<?php echo e(asset('public/assets/js/eva-icons.min.js')); ?>"></script>
		
		<!-- right-sidebar js -->
		<script src="<?php echo e(asset('public/assets/plugins/sidebar/sidebar.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/plugins/sidebar/sidebar-custom.js')); ?>"></script>
		
		<!-- Sticky js -->
		<script src="<?php echo e(asset('public/assets/js/sticky.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/js/modal-popup.js')); ?>"></script>
		
		<!-- Left-menu js-->
		<script src="<?php echo e(asset('public/assets/plugins/side-menu/sidemenu.js')); ?>"></script>
		
		<!-- Internal Map -->
		<script src="<?php echo e(asset('public/assets/plugins/jqvmap/jquery.vmap.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/plugins/jqvmap/maps/jquery.vmap.usa.js')); ?>"></script>
		
		<!--Internal  index js -->
		<script src="<?php echo e(asset('public/assets/js/index.js')); ?>"></script>
		
		<!-- Apexchart js-->
		<script src="<?php echo e(asset('public/assets/js/apexcharts.js')); ?>"></script>
		<script src="<?php echo e(asset('public/assets/js/jquery.vmap.sampledata.js')); ?>"></script>
		
		<!-- custom js -->
		<script src="<?php echo e(asset('public/assets/js/custom.js')); ?>"></script>
		
		<!-- Sweet Alert js-->
		<script src="<?php echo e(asset('public/assets/js/sweetalert.js')); ?>"></script>
		
		<!-- Datatable js-->
		<script src="//cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
		
		<!-- Script js -->
		<script src="<?php echo e(asset('public/script/app.js')); ?>"></script>
		
		
		
		<?php echo $__env->yieldContent('scripts'); ?>
	</body>
	</html><?php /**PATH /var/www/vhosts/inteapps.com/dev.inteapps.com/alakhbar/application/resources/views/layouts/app.blade.php ENDPATH**/ ?>