@extends('layouts.app')

@section('content')

<!-- container -->
<div class="container-fluid">
   <!-- breadcrumb -->
   <div class="breadcrumb-header justify-content-between">
      <div class="my-auto">
         <div class="d-flex">
            <h4 class="content-title mb-0 my-auto">{!!trans('news.news')!!}</h4>
         </div>
      </div>
   </div>
   <!-- breadcrumb -->
   
   <!-- row opened-->
   <div class="row">
      <div class="col-12 col-sm-12 col-lg-12 col-xl-12">
         <div class="card">
            <div class="card-body">
               <!-- Tabs -->
               <div class="panel panel-primary tabs-style-3 border-0">
                  <div class="tab-menu-heading">
                     <div class="tabs-menu ">
                        <!-- Tabs -->
                        <ul class="nav panel-tabs">
                           <li class=""><a href="#register" class="active" data-bs-toggle="tab">
                              <i class="fa-solid fa-file-pen"></i> {!!trans('news.register')!!}</a>
                           </li>
                           <li><a href="#table" data-bs-toggle="tab">
                              <i class="fa-solid fa-magnifying-glass"></i> {!!trans('news.consult')!!}</a>
                           </li>
                        </ul>
                     </div>
                  </div>
                  <div class="panel-body tabs-menu-body">
                     <div class="tab-content">
                        <!-- Tab Register -->
                        <div class="tab-pane active" id="register">
                           <div class="form-group">
                              <label for="exclusive">{!!trans('news.exclusive')!!}</label>
                              <select class="form-control" id="exclusive" name="exclusive">
                                 <option value="ar" selected>{!!trans('news.arabic')!!}</option>
                                 <option value="fr">{!!trans('news.french')!!}</option>
                                 <option value="both">{!!trans('news.both')!!}</option>
                              </select>
                           </div>
                           <div class="form-group">
                              <label for="title_ara">{!!trans('news.arabic_title')!!}</label>
                              <!--
                                 <div id="quill_title_ara"></div>
                              -->
                              <input type="text" class="form-control" id="title_ara" name="title_ara" placeholder="{!!trans('news.arabic_title')!!}">
                           </div>
                           <div class="form-group">
                              <label for="title_fr">{!!trans('news.french_title')!!}</label>
                              <!--
                                 <div id="quill_title_fr"></div>
                              -->
                              <input type="text" class="form-control" id="title_fr" name="title_fr" placeholder="{!!trans('news.french_title')!!}">
                           </div>
                           <div class="form-group">
                              <label for="description_ara">{!!trans('news.arabic_description')!!}</label>
                              <textarea class="form-control" id="description_ara" name="description_ara" rows="3" dir='rtl' lang='ar'></textarea>
                           </div>
                           <div class="form-group">
                              <label for="description_fr">{!!trans('news.french_description')!!}</label>
                              <textarea class="form-control" id="description_fr" name="description_fr" rows="3" dir='rtl' lang='ar'></textarea>
                           </div>
                           <div class="form-group">
                              <div class="row">
                                 <div class="col-5">
                                    <div class="row">
                                       <div class="col-12">
                                          <label for="image">{!!trans('news.french_content')!!}</label>
                                          <hr>
                                          <button id="btn-insert-text-fr" type="button" class="btn btn-info" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.text')!!}">
                                             <i class="fa fa-font"></i>
                                          </button>
                                          <button id="btn-insert-image-fr" type="button" class="btn btn-primary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.image')!!}">
                                             <i class="fa fa-image"></i>
                                          </button>
                                          <button id="btn-insert-video-fr" type="button" class="btn btn-danger" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video')!!}">
                                             <i class="fa fa-video"></i>
                                          </button>
                                          <button id="btn-insert-video-server-fr" type="button" class="btn btn-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video_server')!!}">
                                             <i class="fa-solid fa-upload"></i>
                                          </button>
                                       </div>
                                    </div>
                                    <hr>
                                    <div class="container-section" id="section-fr">
                                    </div>
                                 </div>
                                 <div class="col-2"></div>
                                 <div class="col-5">
                                    <div class="row">
                                       <div class="col-12">
                                          <label for="image">{!!trans('news.arabic_content')!!}</label>
                                          <hr>
                                          <button id="btn-insert-text-ar" type="button" class="btn btn-info" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.text')!!}">
                                             <i class="fa fa-font"></i>
                                          </button>
                                          <button id="btn-insert-image-ar" type="button" class="btn btn-primary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.image')!!}">
                                             <i class="fa fa-image"></i>
                                          </button>
                                          <button id="btn-insert-video-ar" type="button" class="btn btn-danger" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video')!!}">
                                             <i class="fa fa-video"></i>
                                          </button>
                                          <button id="btn-insert-video-server-ar" type="button" class="btn btn-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video_server')!!}">
                                             <i class="fa-solid fa-upload"></i>
                                          </button>
                                       </div>
                                    </div>
                                    <hr>
                                    <div class="container-section" id="section-ar" style="direction: rtl !important;">
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-group">
                              <label for="type">{!!trans('news.type')!!}</label>
                              <select class="form-control" id="type" name="type">
                                 <option value="text">{!!trans('news.text')!!}</option>
                                 <option value="video">{!!trans('news.video')!!}</option>
                              </select>
                           </div>
                           <div class="form-group">
                              <label for="url">{!!trans('news.url')!!}</label>
                              <input type="text" class="form-control" id="url" name="url" placeholder="{!!trans('news.enter_url')!!}">
                           </div>
                           <div class="form-group">
                              <label for="author_ar">{!!trans('news.author_ar')!!}</label>
                              <input type="text" class="form-control" id="author_ar" name="author_ar" placeholder="{!!trans('news.enter_author_ar')!!}">
                           </div>
                           <div class="form-group">
                              <label for="author_fr">{!!trans('news.author_fr')!!}</label>
                              <input type="text" class="form-control" id="author_fr" name="author_fr" placeholder="{!!trans('news.enter_author_fr')!!}">
                           </div>
                           <div class="form-group" style="display: none" id="url_video_div">
                              <label for="url_video">{!!trans('news.url_video')!!}</label>
                              <div class="input-group">
                                 <input type="text" class="form-control" id="url_video" name="url_video" placeholder="{!!trans('news.enter_url_video')!!}">
                                 <button id="btn-insert-video-server" type="button" class="btn btn-secondary">
                                    <i class="fa-solid fa-upload"></i>
                                 </button>
                              </div>
                           </div>
                           <div class="form-group">
                              <label for="image">{!!trans('news.image')!!}</label>
                              <input type="file" class="form-control browse-file" id="image" name="image">
                           </div>
                           <div class="form-group">
                              <label for="category_id">{!!trans('news.select_category')!!}</label>
                              <select class="form-control" id="category_id" name="category_id">
                              </select>
                           </div>
                           <div class="form-group">
                              <label for="status">{!!trans('news.status')!!}</label>
                              <select class="form-control" id="status" name="status">
                                 <option value="active">{!!trans('news.active')!!}</option>
                                 <option value="inactive">{!!trans('news.inactive')!!}</option>
                              </select>
                           </div>
                           <div class="form-group">
                              <button type="button" class="btn btn-block btn-primary-alakbar" id="btn-save-notice">
                                 <i class="fa fa-save"></i> {!!trans('news.register')!!}
                              </button>
                           </div>
                        </div>
                        <!-- end Tab register -->
                        <!-- Start Tab Table-->
                        <div class="tab-pane" id="table">
                           <div class="table-responsive">
                              <table class="table mg-b-0 text-md-nowrap" id="table-notice" style="width:100%">
                                 <thead>
                                    <tr>
                                       <th>{!!trans('news.order')!!}</th>
                                       <th>{!!trans('news.arabic_title')!!}</th>
                                       <th>{!!trans('news.french_title')!!}</th>
                                       <th>{!!trans('news.arabic_description')!!}</th>
                                       <th>{!!trans('news.french_description')!!}</th>
                                       <th>{!!trans('news.type')!!}</th>
                                       <th>{!!trans('news.category')!!}</th>
                                       <th>{!!trans('news.status')!!}</th>
                                       <th>{!!trans('news.action')!!}</th>
                                    </tr>
                                 </thead>
                                 <tbody id="table-body-notice">
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <!-- End Tab Table-->
                     </div>
                  </div>
               </div>
               <!-- Tabs -->
            </div>
         </div>
      </div>
   </div>
   <!--row closed-->
   
</div>
<!-- /Container -->
</div>
<!-- /main-content -->

<!--Modal editar categoria-->
<div class="modal fade " id="modal-edit-notice" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa fa-edit"></i> {!!trans('news.edit_news')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div class="form-group d-none">
                     <input type="text" class="form-control hidden" id="modal_id_notice" name="modal_id">
                  </div>
                  <div class="form-group">
                     <label for="modal_exclusive">{!!trans('news.exclusive')!!}</label>
                     <select class="form-control" id="modal_exclusive" name="modal_exclusive">
                        <option value="ar" selected>{!!trans('news.arabic')!!}</option>
                        <option value="fr">{!!trans('news.french')!!}</option>
                        <option value="both">{!!trans('news.both')!!}</option>
                     </select>
                  </div>
                  <div class="form-group">
                     <label for="modal_title_ara">{!!trans('news.arabic_title')!!}</label>
                     <!--
                        <div id="quill_modal_title_ara"></div>
                     -->
                     <input type="text" class="form-control" id="modal_title_ara" name="modal_title_ara" placeholder="{!!trans('news.enter_arabic_title')!!}">
                  </div>
                  <div class="form-group">
                     <label for="modal_title_fr">{!!trans('news.french_title')!!}</label>
                     <!--
                        <div id="quill_modal_title_fr"></div>
                     -->
                     <input type="text" class="form-control" id="modal_title_fr" name="modal_title_fr" placeholder="{!!trans('news.enter_french_title')!!}">
                  </div>
                  <div class="form-group">
                     <label for="modal_description_ar">{!!trans('news.arabic_description')!!}</label>
                     <textarea class="form-control" id="modal_description_ara" name="modal_description_ar" placeholder="{!!trans('news.enter_description')!!}" dir='rtl' lang='ar'></textarea>
                  </div>
                  <div class="form-group">
                     <label for="modal_description_fr">{!!trans('news.french_description')!!}</label>
                     <textarea class="form-control" id="modal_description_fr" name="modal_description_fr" placeholder="{!!trans('news.enter_description')!!}" dir='rtl' lang='ar'></textarea>
                  </div>
               </div>
               <div class="form-group">
                  <div class="row">
                     <div class="col-5">
                        <div class="row">
                           <div class="col-12">
                              <label for="image">{!!trans('news.french_content')!!}</label>
                              <hr>
                              <button id="modal-btn-insert-text-fr" type="button" class="btn btn-info" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.text')!!}">
                                 <i class="fa fa-font"></i>
                              </button>
                              <button id="modal-btn-insert-image-fr" type="button" class="btn btn-primary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.image')!!}">
                                 <i class="fa fa-image"></i>
                              </button>
                              <button id="modal-btn-insert-video-fr" type="button" class="btn btn-danger" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video')!!}">
                                 <i class="fa fa-video"></i>
                              </button>
                              <!--Modal Upload video to server-->
                              <button id="modal-btn-insert-video-server-fr" type="button" class="btn btn-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video_server')!!}">
                                 <i class="fa-solid fa-upload"></i>
                              </button>
                           </div>
                        </div>
                        <hr>
                        <div class="container-section" id="modal-section-fr">
                        </div>
                     </div>
                     <div class="col-2"></div>
                     <div class="col-5">
                        <div class="row">
                           <div class="col-12">
                              <label for="image">{!!trans('news.arabic_content')!!}</label>
                              <hr>
                              <button id="modal-btn-insert-text-ar" type="button" class="btn btn-info" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.text')!!}">
                                 <i class="fa fa-font"></i>
                              </button>
                              <button id="modal-btn-insert-image-ar" type="button" class="btn btn-primary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.image')!!}">
                                 <i class="fa fa-image"></i>
                              </button>
                              <button id="modal-btn-insert-video-ar" type="button" class="btn btn-danger" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video')!!}">
                                 <i class="fa fa-video"></i>
                              </button>
                              <button id="modal-btn-insert-video-server-ar" type="button" class="btn btn-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="{!!trans('news.video_server')!!}">
                                 <i class="fa-solid fa-upload"></i>
                              </button>
                           </div>
                        </div>
                        <hr>
                        <div class="container-section" id="modal-section-ar" style="direction: rtl !important;">
                        </div>
                     </div>
                  </div>
               </div>
               <div class="form-group">
                  <label for="modal_type">{!!trans('news.type')!!}</label>
                  <select class="form-control" id="modal_type" name="modal_type">
                     <option value="text">{!!trans('news.text')!!}</option>
                     <option value="video">{!!trans('news.video')!!}</option>
                  </select>
               </div>
               <div class="form-group">
                  <label for="modal_url">{!!trans('news.url')!!}</label>
                  <input type="text" class="form-control" id="modal_url" name="modal_url" placeholder="{!!trans('news.enter_url')!!}">
               </div>
               <div class="form-group">
                  <label for="author_ar">{!!trans('news.author_ar')!!}</label>
                  <input type="text" class="form-control" id="modal_author_ar" name="author_ar" placeholder="{!!trans('news.enter_author_ar')!!}">
               </div>
               <div class="form-group">
                  <label for="author_fr">{!!trans('news.author_fr')!!}</label>
                  <input type="text" class="form-control" id="modal_author_fr" name="author_fr" placeholder="{!!trans('news.enter_author_fr')!!}">
               </div>
               <div class="form-group" style="display: none" id="modal_url_video_div">
                  <label for="modal_url_video">{!!trans('news.url_video')!!}</label>
                  <div class="input-group">
                     <input type="text" class="form-control" id="modal_url_video" name="modal_url_video" placeholder="{!!trans('news.enter_url_video')!!}">
                     <button id="modal-btn-insert-video-server" type="button" class="btn btn-secondary">
                        <i class="fa-solid fa-upload"></i>
                     </button>
                  </div>
               </div>
               <div class="form-group">
                  <label for="modal_image">{!!trans('news.image')!!}</label>
                  <!-- Show previous image -->
                  <div class="form-group">
                     <img id="modal_image_previous" src="" alt="" class="img-responsive" style="width: 30%; text-align: center; align-content: center; display: ; height: 30%; margin-left: 35%; margin-right: 35%;border-radius: 10%;">
                  </div>
                  <input type="file" class="form-control browse-file" id="modal_image" name="modal_image" >
               </div>
               <div class="form-group">
                  <label for="modal_category_id">{!!trans('news.category')!!}</label>
                  <select class="form-control" id="modal_category_id" name="modal_category_id">
                  </select>
               </div>
               <div class="form-group">
                  <label for="modal_status">{!!trans('news.status')!!}</label>
                  <select class="form-control" id="modal_status" name="modal_status">
                     <option value="active">{!!trans('news.active')!!}</option>
                     <option value="inactive">{!!trans('news.inactive')!!}</option>
                  </select>
               </div>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{!!trans('news.close')!!}</button>
               <button type="button" class="btn btn-primary-alakbar" id="btn-save-notice" onclick="SaveEditNotice()">{!!trans('news.save')!!}</button>
            </div>
         </div>
      </div>
   </div>
</div>

<!-- Modal Upload video to server -->
<div class="modal fade " id="modal-upload-video" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-md" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa-solid fa-upload"></i> {!!trans('news.register_video')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <!-- Input to upload file -->
               <div class="col-12">
                  <div class="form-group">
                     <input type="file" id="register-file-server" name="file" class="form-control">
                  </div>
               </div>
            </div>
            <div class="progress">
               <div id="progress_bar_upload_file"" class="progress-bar" role="progressbar" style="width: 0%; display:none" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">0</div>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{!!trans('news.close')!!}</button>
               <button type="button" class="btn btn-primary-alakbar" id="btn-save-notice" onclick="UploadVideoServer()">{!!trans('news.save')!!}</button>
            </div>
         </div>
      </div>
   </div>
</div>

<!-- Modal Upload video to server -->
<div class="modal fade " id="modal-upload-video-principal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-md" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa-solid fa-upload"></i> {!!trans('news.register_video')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <!-- Input to upload file -->
               <div class="col-12">
                  <div class="form-group">
                     <input type="file" id="register-file-server-principal" name="file" class="form-control">
                  </div>
               </div>
            </div>
            <div class="progress">
               <div id="progress_bar_upload_file_principal"" class="progress-bar" role="progressbar" style="width: 0%; display:none" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">0</div>
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{!!trans('news.close')!!}</button>
               <button type="button" class="btn btn-primary-alakbar" id="btn-save-notice" onclick="UploadVideoServerPrincipal()">{!!trans('news.save')!!}</button>
            </div>
         </div>
      </div>
   </div>
</div>

<!-- Modal Insert text -->
<div class="modal fade" id="modal-insert-text" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa-solid fa-newspaper"></i> {!!trans('news.text')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <!-- Input to insert text -->
               <div class="col-12">
                  <div class="form-group">
                     <textarea id="text-insert" name="text" class="form-control" rows="10" dir='rtl' lang='ar'></textarea>
                  </div>
               </div>
               <!--input hidden to save the text-->
               <input type="hidden" id="text-insert-hidden" name="text" class="form-control">
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" onclick="CancelRegisterInDiv()">{!!trans('news.close')!!}</button>
               <button type="button" class="btn btn-primary-alakbar" id="btn-save-notice" onclick="RegisterInDiv()">{!!trans('news.save')!!}</button>
            </div>
         </div>
      </div>
   </div>
</div>

<!-- Modal Edit text -->
<div class="modal fade" id="modal-edit-text" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa-solid fa-newspaper"></i> {!!trans('news.text')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <!-- Input to insert text -->
               <div class="col-12">
                  <div class="form-group">
                     <textarea id="text-edit" name="text" class="form-control" rows="10" dir='rtl' lang='ar'></textarea>
                  </div>
               </div>
               <!--input hidden to save the text-->
               <input type="hidden" id="text-child-hidden" name="text" class="form-control">
               <input type="hidden" id="text-parent-hidden" name="text" class="form-control">
            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" onclick="CancelEditInDiv()">{!!trans('news.close')!!}</button>
               <button type="button" class="btn btn-primary-alakbar" id="btn-save-notice" onclick="EditInDiv()">{!!trans('news.save')!!}</button>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection

@section('scripts')

<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<link href="https://cdn.datatables.net/rowreorder/1.2.8/css/rowReorder.dataTables.min.css" rel="stylesheet">
<script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/three-dots/0.2.3/three-dots.min.css" integrity="sha512-phLdfZOlarjP3HG/eEMoFHm4ZJ6P4LQJUWgAiTVuvE0hh2UEGIm10jfxYROhWDdd/LrTkGPd0jSx3bACtl9gBA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="{{ asset('public/script/news.js') }}"></script>

<!-- Draggable Libraries -->
<!-- Entire bundle -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/draggable.bundle.js"></script>
<!-- legacy bundle for older browsers (IE11) -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/draggable.bundle.legacy.js"></script>
<!-- Draggable only -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/draggable.js"></script>
<!-- Sortable only -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/sortable.js"></script>
<!-- Droppable only -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/droppable.js"></script>
<!-- Swappable only -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/swappable.js"></script>
<!-- Plugins only -->
<script src="https://cdn.jsdelivr.net/npm/@shopify/draggable@1.0.0-beta.11/lib/plugins.js"></script>
@endsection