@extends('layouts.app')

@section('content')

<!-- container -->
<div class="container-fluid">
   <!-- breadcrumb -->
   <div class="breadcrumb-header justify-content-between">
      <div class="my-auto">
         <div class="d-flex">
            <h4 class="content-title mb-0 my-auto">{!!trans('administrators.administartors')!!}</h4>
         </div>
      </div>
   </div>
   <!-- breadcrumb -->
   
   <!-- row opened-->
   <div class="row">
      <div class="col-12 col-sm-12 col-lg-12 col-xl-12">
         <div class="card">
            <div class="card-body">
               <!-- Tabs -->
               <div class="panel panel-primary tabs-style-3 border-0">
                  <div class="tab-menu-heading">
                     <div class="tabs-menu ">
                        <!-- Tabs -->
                        <ul class="nav panel-tabs">
                           <li class=""><a href="#register" class="active" data-bs-toggle="tab">
                              <i class="fa-solid fa-file-pen"></i> {!!trans('administrators.register')!!}</a>
                           </li>
                           <li><a href="#table" data-bs-toggle="tab">
                              <i class="fa-solid fa-magnifying-glass"></i> {!!trans('administrators.consult')!!}</a>
                           </li>
                        </ul>
                     </div>
                  </div>
                  <div class="panel-body tabs-menu-body">
                     <div class="tab-content">
                        <!-- Tab Register -->
                        <div class="tab-pane active" id="register">
                           <div class="form-group">
                              <label for="name">{!!trans('administrators.name')!!}</label>
                              <input type="text" class="form-control" id="name" placeholder="{!!trans('administrators.name')!!}">
                           </div>
                           <div class="form-group">
                              <label for="email">{!!trans('administrators.email')!!}</label>
                              <input type="email" class="form-control" id="email" placeholder="{!!trans('administrators.email')!!}">
                           </div>
                           <div class="form-group">
                              <label for="password">{!!trans('administrators.password')!!}</label>
                              <input type="password" class="form-control" id="password" placeholder="{!!trans('administrators.password')!!}">
                           </div>
                           <div class="form-group">
                              <p class="mg-b-10">{!!trans('administrators.language')!!}</p>
                              <select class="form-control select2" data-placeholder="{!!trans('administrators.language')!!}" id="language">
                                 <option value="ar">
                                    {!!trans('administrators.arabic')!!}
                                 </option>
                                 <option value="fr">
                                    {!!trans('administrators.french')!!}
                                 </option>
                              </select>
                           </div>
                           <div class="form-group">
                              <button type="button" class="btn btn-block btn-primary-alakbar" id="btn-save-administrator">
                                 <i class="fa fa-save"></i> {!!trans('administrators.register')!!}
                              </button>
                           </div>
                        </div>
                        <!-- end Tab register -->
                        <!-- Start Tab Table-->
                        <div class="tab-pane" id="table">
                           <div class="table-responsive">
                              <table class="table mg-b-0 text-md-nowrap" id="table-users">
                                 <thead>
                                    <tr>
                                       <th>{!!trans('administrators.name')!!}</th>
                                       <th>{!!trans('administrators.email')!!}</th>
                                       <th>{!!trans('administrators.action')!!}</th>
                                    </tr>
                                 </thead>
                                 <tbody id="table-body-users">
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <!-- End Tab Table-->
                     </div>
                  </div>
               </div>
               <!-- Tabs -->
            </div>
         </div>
      </div>
   </div>
   <!--row closed-->
   
</div>
<!-- /Container -->
</div>
<!-- /main-content -->

<!--Modal editar usuario-->
<div class="modal fade" id="modal-edit-user" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa fa-edit"></i> {!!trans('administrators.administrators_edit')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div class="form-group d-none">
                     <input type="text" class="form-control" id="modal_id">
                  </div>
                  <div class="form-group">
                     <label for="modal_name">{!!trans('administrators.name')!!}</label>
                     <input type="text" class="form-control" id="modal_name" placeholder="{!!trans('administrators.name')!!}">
                  </div>
                  <!-- Modal Email -->
                  <div class="form-group">
                     <label for="modal_email">{!!trans('administrators.email')!!}</label>
                     <input type="email" class="form-control" id="modal_email" placeholder="{!!trans('administrators.email')!!}">
                  </div>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{!!trans('administrators.close')!!}</button>
            <button type="button" class="btn btn-primary" id="btn-save-user" onclick="SaveEditUser()">{!!trans('administrators.save')!!}</button>
         </div>
      </div>
   </div>
</div>

@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.js" integrity="sha512-1aNp9qKP+hKU/VJwCtYqJP9tdZWbMDN5pEEXXoXT0pTAxZq1HHZhNBR/dtTNSrHO4U1FsFGGILbqG1O9nl8Mdg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<link href="https://cdn.datatables.net/rowreorder/1.2.8/css/rowReorder.dataTables.min.css" rel="stylesheet">
<script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.css" integrity="sha512-KuSX+43gVS5MEIJD2ewtrFPOHqC1PJnL8o2f5ciggPC0JUZ8XV0QXlfArO1mSzKkVFdRjsBDfrTU96C5SuRfqQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="{{ asset('public/script/administrators.js') }}"></script>
@endsection