<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColorsCategoriesTable extends Migration
{
    /**
    * Run the migrations.
    *
    * @return void
    */
    public function up()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->string('text_color')->default('#ff331a')->after('icon');
            $table->string('icon_color')->default('#ff331a')->after('text_color');
        });
    }
    
    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down()
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn('text_color');
            $table->dropColumn('icon_color');
        });
    }
}
