<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notice extends Model
{
    use HasFactory;

    protected $table = 'notices';

    protected $fillable = [
        'order',
        'exclusive_languaje',
        'author_ar',
        'author_fr',
        'title',
        'description',
        'content',
        'image',
        'category_id',
        'language_id',
        'status',
        'consulted_times',
        'comments',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function language()
    {
        return $this->belongsTo(Language::class, 'language_id');
    }
}
