<?php
// Test the exact query that's failing in NoticeController

echo "<h2>Testing NoticeController Query</h2>";

// Database connection (reuse the working config)
try {
    $envFile = '/home/alakhbarpressapp/public_html/last/application/.env';
    $envContent = file_get_contents($envFile);
    
    preg_match('/DB_HOST=(.*)/', $envContent, $hostMatch);
    preg_match('/DB_DATABASE=(.*)/', $envContent, $dbMatch);
    preg_match('/DB_USERNAME=(.*)/', $envContent, $userMatch);
    preg_match('/DB_PASSWORD=(.*)/', $envContent, $passMatch);
    
    $host = isset($hostMatch[1]) ? trim($hostMatch[1]) : 'localhost';
    $database = isset($dbMatch[1]) ? trim($dbMatch[1]) : '';
    $username = isset($userMatch[1]) ? trim($userMatch[1]) : '';
    $password = isset($passMatch[1]) ? trim($passMatch[1]) : '';
    
    $dsn = "mysql:host=$host;dbname=$database;charset=utf8mb4";
    $pdo = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<p>✅ Database connected</p>";
    
    // Check table structures first
    echo "<h3>1. Checking 'notices' table structure...</h3>";
    $stmt = $pdo->query("DESCRIBE notices");
    $noticesColumns = $stmt->fetchAll();
    
    echo "<p><strong>Notices table columns:</strong></p>";
    echo "<ul>";
    foreach ($noticesColumns as $col) {
        echo "<li>" . htmlspecialchars($col['Field']) . " (" . htmlspecialchars($col['Type']) . ")</li>";
    }
    echo "</ul>";
    
    echo "<h3>2. Checking 'categories' table structure...</h3>";
    $stmt = $pdo->query("DESCRIBE categories");
    $categoriesColumns = $stmt->fetchAll();
    
    echo "<p><strong>Categories table columns:</strong></p>";
    echo "<ul>";
    foreach ($categoriesColumns as $col) {
        echo "<li>" . htmlspecialchars($col['Field']) . " (" . htmlspecialchars($col['Type']) . ")</li>";
    }
    echo "</ul>";
    
    // Test the exact query from NoticeController
    echo "<h3>3. Testing the exact NoticeController query...</h3>";
    
    $sql = "SELECT notices.*, categories.name_ara as category_name_ara, categories.name_fr as category_name_fr 
            FROM notices 
            JOIN categories ON categories.id = notices.category_id 
            ORDER BY notices.order DESC 
            LIMIT 5";
    
    echo "<p><strong>Query:</strong></p>";
    echo "<pre>" . htmlspecialchars($sql) . "</pre>";
    
    try {
        $stmt = $pdo->query($sql);
        $results = $stmt->fetchAll();
        
        echo "<p>✅ Query successful! Found " . count($results) . " records</p>";
        
        if (count($results) > 0) {
            echo "<p><strong>First record:</strong></p>";
            echo "<pre>" . htmlspecialchars(json_encode($results[0], JSON_PRETTY_PRINT)) . "</pre>";
        }
        
    } catch (Exception $e) {
        echo "<p>❌ Query failed: " . htmlspecialchars($e->getMessage()) . "</p>";
        
        // Try a simpler query to isolate the issue
        echo "<h4>Testing simpler queries...</h4>";
        
        try {
            $stmt = $pdo->query("SELECT * FROM notices LIMIT 1");
            $result = $stmt->fetch();
            echo "<p>✅ Simple notices query works</p>";
        } catch (Exception $e2) {
            echo "<p>❌ Simple notices query failed: " . htmlspecialchars($e2->getMessage()) . "</p>";
        }
        
        try {
            $stmt = $pdo->query("SELECT * FROM categories LIMIT 1");
            $result = $stmt->fetch();
            echo "<p>✅ Simple categories query works</p>";
        } catch (Exception $e3) {
            echo "<p>❌ Simple categories query failed: " . htmlspecialchars($e3->getMessage()) . "</p>";
        }
    }
    
    // Test if 'order' column exists in notices table
    echo "<h3>4. Checking for 'order' column...</h3>";
    $hasOrderColumn = false;
    foreach ($noticesColumns as $col) {
        if ($col['Field'] === 'order') {
            $hasOrderColumn = true;
            break;
        }
    }
    
    if ($hasOrderColumn) {
        echo "<p>✅ 'order' column exists in notices table</p>";
    } else {
        echo "<p>❌ 'order' column missing in notices table</p>";
        echo "<p>This might be the cause of the 500 error!</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
