function SignInUser(){
   $('#btn-signin').attr('disabled', true);
   
   let email = $('#user_email').val();
   let password = $('#user_password').val();
   
   let formData = new FormData();
   formData.append('email', email);
   formData.append('password', password);
   formData.append('language', language);
   
   Swal.fire({
      title: lang_wait,
      text: lang_data_valide,
      confirmButtonColor: '#fb3219',
   });
   
   var url = 'api/user/login';
   
   setTimeout(function(){
      
      $.ajax({
         url: url,
         type: 'POST',
         data: formData,
         contentType: false,
         processData: false,
         headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
         },
         success: function(data){
            if(data.status)
            {
               localStorage.setItem('user', JSON.stringify(data.user));
               localStorage.setItem('language', data.user.language);
               var user = localStorage.getItem('user');
               user = JSON.parse(user);
               window.location.href = 'home/';
               
               $('#btn-signin').attr('disabled', false);
               
            }
            else
            {
               Swal.fire({
                  title: lang_error,
                  text: data.message,
                  type: 'error',
                  confirmButtonColor: '#0162e8',
               });
               $('#btn-signin').attr('disabled', false);
            }
         },
         error: function(data){
            Swal.fire({
               title: lang_error,
               text: lang_error_login,
               type: 'error',
               confirmButtonColor: '#0162e8',
            });
            $('#btn-signin').attr('disabled', false);
         }
      });
   }, 1000);
}


$(document).ready(function(){
   let please_sign = language == 'ar' ? 'الرجاء التسجيل' : 'S\'il vous plaît signer';
   let email_label = language == 'ar' ? 'البريد الإلكتروني' : 'Email';
   let password_label = language == 'ar' ? 'كلمة المرور' : 'Mot de passe';
   let email_placeholder = language == 'ar' ? 'البريد الإلكتروني' : 'Email';
   let password_placeholder = language == 'ar' ? 'كلمة المرور' : 'Mot de passe';
   let btn_signin = language == 'ar' ? 'يسجل دخول' : 'Commencer la session';
   
   document.getElementById('please_sign').innerHTML = please_sign;
   document.getElementById('email_label').innerHTML = email_label;
   document.getElementById('password_label').innerHTML = password_label;
   document.getElementById('user_email').placeholder = email_placeholder;
   document.getElementById('user_password').placeholder = password_placeholder;
   document.getElementById('btn-signin').innerHTML = btn_signin;
});