var content_ara = '';
var content_fr = '';
var content_modal_ara = '';
var content_modal_fr = '';

var test = null;
var dragSrcEl = null;

var table = null;

let result_console = null;

let row_id = null;
let modal_section = null;
let row_drag = null;
let modal_enabled = false;
let register_url_video_principal = false;

var quil_title_ara = '';
var quil_title_fr = '';
var quil_modal_title_ara = '';
var quil_modal_title_fr = '';

var quil_text_modal_fr = '';

var btn_edit_test = null;


var toolbarOptions = [
   ['bold', 'italic', 'underline', 'strike'],
   [{ 'color': [ '#000000', '#e60000', '#ff9900', '#ffff00', '#008a00', '#0066cc', '#9933ff', '#ffffff', '#facccc', '#ffebcc', '#ffffcc', '#cce8cc', '#cce0f5', '#ebd6ff', ] }],
   [{ 'background': [ '#000000', '#e60000', '#ff9900', '#ffff00', '#008a00', '#0066cc', '#9933ff', '#ffffff', '#facccc', '#ffebcc', '#ffffcc', '#cce8cc', '#cce0f5', '#ebd6ff', ] }],
];

var toolbarOptionsContent = [
   ['bold', 'italic', 'underline', 'strike']
];

function LoadCategoriesOptions(){
   
   // Define language variable if not already defined
   let language = (typeof window.language !== 'undefined') ? window.language : 'ar';
   
   let data = {
      language: language,
      status:"true"
   }
   
   $.ajax({
      url: 'api/category/get/all',
      type: 'POST',
      data: data,
      success: function(response){
         if(response.status){
            let categories = response.data;
            let options = '';
            for(let i = 0; i < categories.length; i++){
               options += '<option value="'+categories[i].id+'">';
               if(language == 'ar'){
                  options += categories[i].name_ara;
               }else{
                  options += categories[i].name_fr;
               }
               options += '</option>';
            }
            $('#category_id').html(options);
            $('#modal_category_id').html(options);
         }
      },
      error: function(error) {
      }
   });
   
}

function LoadCategories(){
   // Define language variable if not already defined
   let language = (typeof window.language !== 'undefined') ? window.language : 'ar';
   
   let data = {
      language: language,
      status: 'all'
   }
   
   $.ajax({
      url: 'api_bypass.php',
      type: 'POST',
      data: data,
      dataType: 'json',
      success: function(response) {
         if(response.status){
            let language_datatable = '';
            
            if(language == 'ar'){
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json"
            }else{
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/French.json"
            }
            
            table = $('#table-notice').DataTable({
               "processing": true,
               "serverSide": true,
               "ajax": {
                  "url": "api/notice/get/all/paginate",
                  "type": "POST",
                  "data": {
                     language: language,
                     status: 'all'
                  }
               },
               "language": {
                  "url": language_datatable
               },
               "columns": [
                  { "data": "order" },
                  { "data": "title_ara" },
                  { "data": "title_fr" },
                  { "data": "description_ara" },
                  { "data": "description_fr" },
                  { "data": "type" },
                  { "data": "category_name" },
                  { "data": "status" },
                  { "data": "action" },
               ],
               "rowReorder": {
                  dataSrc: "order",
                  selector: 'td:not(:last-child)'
               },
               "columnDefs": [
                  { "orderable": false, "targets": [0] },
                  { "orderable": false, "targets": [1] },
                  { "orderable": false, "targets": [2] },
                  { "orderable": false, "targets": [3] },
                  { "orderable": false, "targets": [4] },
                  { "orderable": false, "targets": [5] },
                  { "orderable": false, "targets": [6] },
                  { "orderable": false, "targets": [7] },
                  { "orderable": false, "targets": [8] },
               ],
               "order": [[ 0, "asc" ]],
               responsive: true,
               "scrollCollapse": true,
               "paging": true,
               "lengthChange": true,
               "searching": true,
               "width": "100%",
               "rowReorder": true,
            });
            
            rowReorder = false;
            
            table.on( 'search.dt', function () {
               if(table.search() != ''){
                  table.rowReorder.disable();
               }else{
                  if(rowReorder == false){
                     table.rowReorder.enable();
                  }
               }
            });
            
            table.on('row-reordered', function (e, diff, edit) {   
               table.rowReorder.disable();
               
               if(!diff.length){return;}
               if(rowReorder){return;}
               
               rowReorder = true;
               
               let page = table.page.info().page;
               let length = table.page.info().length;
               let multiple = page * length;
               
               let data = {};
               
               for(var i=0; i<diff.length; i++){
                  let id = diff[i].node.children[8].children[0].id;
                  id = id.replace('n_', '');
                  let order = diff[i].newPosition + 1;
                  order = multiple + order;
                  
                  let object = {
                     id: id,
                     order: order
                  }
                  
                  data[i] = object;
                  
               }
               
               data['language'] = language;
               
               $.ajax({
                  url: 'api/notice/update/order',
                  type: 'POST',
                  data: data,
                  dataType: 'json',
                  success: function(response) {
                     if(response.status){
                        toast(lang_order_updated, 'success');
                     }else{
                        toast(response.message, 'error');
                     }
                  },
                  error: function(error) {
                     console.log(error);
                  },
                  complete: function() {
                     setTimeout(function(){
                        rowReorder = false;
                        table.rowReorder.enable();
                     }, 1000);
                  }
               }); 
            });
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function getContentRegister(id){
   let container = document.getElementById(id);
   let childs = container.children;
   
   let html = '';
   
   for(let i = 0; i < childs.length; i++){
      html += childs[i].firstChild.firstChild.firstChild.firstChild.innerHTML;
      html = html.replace('<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></button>', '');
      html = html.replace('<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>', '');
      //console.log(html);
   }
   
   return html;
}

function RegisterNotice() {
   
   let title_ara = $('#title_ara').val();
   let title_fr = $('#title_fr').val();
   //let title_ara = getQuillData(quil_title_ara);
   //let title_fr = getQuillData(quil_title_fr);
   let description_ara = $('#description_ara').val();
   let description_fr = $('#description_fr').val();
   content_ara = getContentRegister('section-ar');
   content_fr = getContentRegister('section-fr');
   let type = $('#type').val();
   let url = $('#url').val();
   let author_ar = $('#author_ar').val();
   let author_fr = $('#author_fr').val();
   let url_video = $('#url_video').val();
   let image = $('#image')[0].files[0];
   let category_id = $('#category_id').val();
   let status = $('#status').val();
   let exclusive = $('#exclusive').val();
   
   //TRIM
   title_ara = title_ara.trim();
   title_fr = title_fr.trim();
   
   let data = new FormData();
   data.append('title_ara', title_ara);
   data.append('title_fr', title_fr);
   data.append('description_ara', description_ara);
   data.append('description_fr', description_fr);
   data.append('content_ara', content_ara);
   data.append('content_fr', content_fr);
   data.append('type', type);
   data.append('url', url);
   data.append('author_ar', author_ar);
   data.append('author_fr', author_fr);
   if(url_video != ''){
      data.append('url_video', url_video);
   }else{
      data.append('url_video', 'No video');
   }
   data.append('image', image);
   data.append('category_id', category_id);
   data.append('status', status);
   data.append('language', language);
   data.append('exclusive', exclusive);
   
   if(type == 'video'){
      if(url_video == ''){
         toast(lang_video_url_required, 'error');
         return;
      }
   }
   
   $.ajax({
      url: 'api/notice/register',
      type: 'POST',
      contentType: false,
      processData: false,
      data: data,
      dataType: 'json',
      success: function(response) {
         if(response.status){
            $('#title_ara').val('');
            $('#title_fr').val('');
            //clearQuillData(quil_title_ara);
            //clearQuillData(quil_title_fr);
            $('#description_ara').val('');
            $('#description_fr').val('');
            $('#type').val('');
            $('#url').val('');
            $('#author_ar').val('');
            $('#author_fr').val('');
            $('#image').val('');
            $('#category-id').val('');
            $('#url_video').val('');
            ClearDiv('section-ar');
            ClearDiv('section-fr');
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(xhr) {
         if (xhr && xhr.status == 413) {
            toast(lang_video_max_size, 'error');
         } else {
            console.error('RegisterNotice error:', xhr);
            var msg = (xhr && xhr.responseJSON && xhr.responseJSON.message) ? xhr.responseJSON.message : 'Failed to register notice. Check server logs.';
            toast(msg, 'error');
         }
      }
   });
   
}

function ClearDiv(id){
   let container = document.getElementById(id);
   
   //Eliminar todos los hijos de un div
   while (container.hasChildNodes()) {
      container.removeChild(container.lastChild);
   }
}

function SaveEditNotice() {
   
   let id = $('#modal_id_notice').val();
   let title_ara = $('#modal_title_ara').val();
   let title_fr = $('#modal_title_fr').val();
   //let title_ara = getQuillData(quil_modal_title_ara);
   //let title_fr = getQuillData(quil_modal_title_fr);
   let description_ara = $('#modal_description_ara').val();
   let description_fr = $('#modal_description_fr').val();
   content_ara = getContentRegister('modal-section-ar');
   content_fr = getContentRegister('modal-section-fr');
   let type = $('#modal_type').val();
   let url = $('#modal_url').val();
   let author_ar = $('#modal_author_ar').val();
   let author_fr = $('#modal_author_fr').val();
   let url_video = $('#modal_url_video').val();
   let image = $('#modal_image')[0].files[0];
   if(image == undefined)
   {
      image = false;
   }
   let category_id = $('#modal_category_id').val();
   let status = $('#modal_status').val();
   let exclusive = $('#modal_exclusive').val();
   
   //TRIM
   title_ara = title_ara.trim();
   title_fr = title_fr.trim();
   
   let data = new FormData();
   data.append('id', id);
   data.append('title_ara', title_ara);
   data.append('title_fr', title_fr);
   data.append('description_ara', description_ara);
   data.append('description_fr', description_fr);
   data.append('content_ara', content_ara);
   data.append('content_fr', content_fr);
   data.append('type', type);
   data.append('url', url);
   data.append('author_ar', author_ar);
   data.append('author_fr', author_fr);
   if(url_video != ''){
      data.append('url_video', url_video);
   }else{
      data.append('url_video', 'No video');
   }
   data.append('image', image);
   data.append('category_id', category_id);
   data.append('status', status);
   data.append('language', language);
   data.append('exclusive', exclusive);
   
   if(type == 'video'){
      if(url_video == ''){
         toast(lang_video_url_required, 'error');
         return;
      }
   }
   
   $.ajax({
      url: 'api/notice/update',
      type: 'POST',
      data: data,
      contentType: false,
      processData: false,
      dataType: 'json',
      success: function(response) {
         if(response.status){
            toast('Noticia actualizada con exito', 'success');
            $('#modal_name_ara').val('');
            $('#modal_name_fr').val('');
            //clearQuillData(quil_modal_title_ara);
            //clearQuillData(quil_modal_title_fr);
            $('#modal_type').val('');
            $('#modal_url').val('');
            $('#modal_author_ar').val('');
            $('#modal_author_fr').val('');
            $('#modal_image').val('');
            $('#modal_category_id').val('');
            $('#modal_status').val('');
            $('#modal_id_notice').val('');
            $('#modal-edit-notice').modal('hide');
            $('#modal_exclusive').val('');
            ClearDiv('modal-section-ar');
            ClearDiv('modal-section-fr');
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(xhr) {
         if (xhr && xhr.status == 413) {
            toast(lang_video_max_size, 'error');
         } else {
            console.error('SaveEditNotice error:', xhr);
            var msg = (xhr && xhr.responseJSON && xhr.responseJSON.message) ? xhr.responseJSON.message : 'Failed to update notice. Check server logs.';
            toast(msg, 'error');
         }
      }
   });
   
}

function DeleteNotice(id){
   
   let data = {
      language: language,
      id: id
   };
   
   Swal.fire({
      title: lang_title_question,
      text: lang_title_text,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: lang_config_button_text,
      cancelButtonText: lang_cancel_button_text
   }).then((result) => {
      if (result.value) {
         $.ajax({
            url: 'api/notice/delete',
            type: 'POST',
            data: data,
            success: function(response){
               if(response.status) {
                  table.ajax.reload(null, false);
                  toast(response.message, 'success');
               }else{
                  toast(response.message, 'error');
               }
            },
            error: function(error) {
               console.log(error);
            }
         });
      }
   })
}

function EditNoticeModal(id)
{
   let data = {
      language: language,
      id: id
   };
   
   $.ajax({
      data: data,
      url: 'api/notice/get/id',
      type: 'POST',
      success: function(response) {
         if(response.status)
         {
            
            let notice = response.data;
            
            $('#modal_title_ara').val(notice.title_ara);
            $('#modal_title_fr').val(notice.title_fr);
            
            //setQuillData(quil_modal_title_ara,notice.title_ara);
            //setQuillData(quil_modal_title_fr,notice.title_fr);
            
            $('#modal_description_ara').val(notice.description_ara);
            $('#modal_description_fr').val(notice.description_fr);
            $('#modal_type').val(notice.type);
            $('#modal_url').val(notice.url);
            $('#modal_author_ar').val(notice.author_ar);
            $('#modal_author_fr').val(notice.author_fr);
            if(notice.type == 'video'){
               $('#modal_url_video').val(notice.url_video);
               $('#modal_url_video_div').show();
            }else{
               $('#modal_url_video_div').hide();
            }
            $('#modal_image_previous').attr('src',notice.image);
            $('#modal_category_id').val(notice.category_id);
            $('#modal_status').val(notice.status);
            $('#modal_id_notice').val(notice.id);
            $('#modal_exclusive').val(notice.exclusive_languaje);
            
            //console.log('New in ara');
            //console.log(notice.content_ara);
            //console.log('New in fr');
            //console.log(notice.content_fr);
            
            //Separar las etiquetas por span
            
            //Validar si el contenido es null
            let content_ara = '';
            let content_fr = '';

            if(notice.content_ara != null){
               content_ara = notice.content_ara.split('<span');
            }
            
            if(notice.content_fr != null){
               content_fr = notice.content_fr.split('<span');
            }
            
            let content_ara_html = '';
            
            let id_for_element = 0;
            
            for(let i = 0; i < content_ara.length; i++)
            {
               if(content_ara[i].indexOf('text-new') != -1)
               {
                  
                  
                  content_ara_html += '<div class="row row-drag-ar" draggable="true" id="row-ar-modal-'+id_for_element+'">';
                  content_ara_html += '<div class="col-12 col-drag">';
                  content_ara_html += '<div class="card bg-info text-white section-drag">';
                  content_ara_html += '<div class="card-body card-drag">';
                  content_ara_html += '<div class="card-content-drag">';
                  content_ara_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_ara_html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
                  content_ara_html += '<span';
                  content_ara_html += content_ara[i].replace('</span>','');
                  content_ara_html += '</span>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  
                  id_for_element++;
               }
               
               if(content_ara[i].indexOf('img-new') != -1){
                  content_ara_html += '<div class="row row-drag-ar" draggable="true">';
                  content_ara_html += '<div class="col-12 col-drag">';
                  content_ara_html += '<div class="card text-white section-drag">';
                  content_ara_html += '<div class="card-body card-drag">';
                  content_ara_html += '<div class="card-content-drag">';
                  content_ara_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_ara_html += '<span';
                  content_ara_html += content_ara[i].replace('</span>','');
                  content_ara_html += '</span>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
               }
               
               if(content_ara[i].indexOf('video-new') != -1){
                  content_ara_html += '<div class="row row-drag-ar" draggable="true">';
                  content_ara_html += '<div class="col-12 col-drag">';
                  content_ara_html += '<div class="card text-white section-drag">';
                  content_ara_html += '<div class="card-body card-drag">';
                  content_ara_html += '<div class="card-content-drag">';
                  content_ara_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_ara_html += '<span';
                  content_ara_html += content_ara[i].replace('</span>','');
                  content_ara_html += '</span>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
                  content_ara_html += '</div>';
               }
               
               
            }
            
            $('#modal-section-ar').html(content_ara_html);
            
            let itemsar = document.querySelectorAll('.row-drag-ar');
            
            itemsar.forEach(function(item) {
               item.removeEventListener('dragstart', handleDragStart, false);
               item.removeEventListener('dragover', handleDragOver, false);
               item.removeEventListener('drop', handleDrop, false);
               item.removeEventListener('dragend', handleDragEnd, false);
            });
            
            itemsar.forEach(function(item) {
               item.addEventListener('dragstart', handleDragStart, false);
               item.addEventListener('dragover', handleDragOver, false);
               item.addEventListener('drop', handleDrop, false);
               item.addEventListener('dragend', handleDragEnd, false);
            });
            
            let content_fr_html = '';
            
            for(let i = 0; i < content_fr.length; i++)
            {
               if(content_fr[i].indexOf('text-new') != -1)
               {
                  
                  content_fr_html += '<div class="row row-drag-fr" draggable="true" id="row-fr-modal-'+id_for_element+'">';
                  content_fr_html += '<div class="col-12 col-drag">';
                  content_fr_html += '<div class="card bg-info text-white section-drag">';
                  content_fr_html += '<div class="card-body card-drag">';
                  content_fr_html += '<div class="card-content-drag">';
                  content_fr_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_fr_html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
                  content_fr_html += '<span';
                  content_fr_html += content_fr[i].replace('</span>','');
                  content_fr_html += '</span>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  
                  id_for_element++;
               }
               
               if(content_fr[i].indexOf('img-new') != -1){
                  content_fr_html += '<div class="row row-drag-fr" draggable="true">';
                  content_fr_html += '<div class="col-12 col-drag">';
                  content_fr_html += '<div class="card text-white section-drag">';
                  content_fr_html += '<div class="card-body card-drag">';
                  content_fr_html += '<div class="card-content-drag">';
                  content_fr_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_fr_html += '<span';
                  content_fr_html += content_fr[i].replace('</span>','');
                  content_fr_html += '</span>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
               }
               
               if(content_fr[i].indexOf('video-new') != -1){
                  content_fr_html += '<div class="row row-drag-fr" draggable="true">';
                  content_fr_html += '<div class="col-12 col-drag">';
                  content_fr_html += '<div class="card text-white section-drag">';
                  content_fr_html += '<div class="card-body card-drag">';
                  content_fr_html += '<div class="card-content-drag">';
                  content_fr_html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
                  content_fr_html += '<span';
                  content_fr_html += content_fr[i].replace('</span>','');
                  content_fr_html += '</span>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
                  content_fr_html += '</div>';
               }
            }
            
            $('#modal-section-fr').html(content_fr_html);
            
            let itemsfr = document.querySelectorAll('.row-drag-fr');
            
            itemsfr.forEach(function(item) {
               item.removeEventListener('dragstart', handleDragStart, false);
               item.removeEventListener('dragover', handleDragOver, false);
               item.removeEventListener('drop', handleDrop, false);
               item.removeEventListener('dragend', handleDragEnd, false);
            });
            
            itemsfr.forEach(function(item) {
               item.addEventListener('dragstart', handleDragStart, false);
               item.addEventListener('dragover', handleDragOver, false);
               item.addEventListener('drop', handleDrop, false);
               item.addEventListener('dragend', handleDragEnd, false);
            });
            
            //console.log(content_ara);
            
            $('#modal-edit-notice').modal('show');
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function RemoveDiv(element)
{
   console.log(element);
   element.parentNode.parentNode.parentNode.parentNode.parentNode.remove();
}

function ShowSwalInsertTextFr()
{
   
   $('#modal-edit-notice').modal('hide');
   $('#modal-insert-text').modal('show');
   $('#text-insert-hidden').val('fr-register');
   
   $('#text-insert').val('');
   $('#text-insert').focus();
   
   //Fix scroll
   $('.modal').css('overflow-y', 'hidden');
   
   return;   
}

function ShowSwalInsertImageFr()
{
   
   Swal.fire({
      input: 'file',
      inputLabel: lang_image,
      inputPlaceholder: lang_image_input,
      inputAttributes: {
         'aria-label': lang_image_input
      },
      showCancelButton: true
   }).then((result) => {
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_image_required, 'error');
         return;
      }
      
      let file = result.value;
      let file_type = file.type;
      let valid_image = ['image/jpeg', 'image/png', 'image/jpg'];
      if(valid_image.indexOf(file_type) == -1)
      {
         toast(lang_type_image_required, 'error');
         return;
      }
      
      let reader = new FileReader();
      reader.readAsDataURL(result.value);
      reader.onload = function () {
         let html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span>';
         html += '<img src="'+reader.result+'" class="img-fluid img-new" draggable="false"></img>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         
         document.getElementById('section-fr').innerHTML += html;
         
         let items = document.querySelectorAll('.row-drag-fr');
         
         items.forEach(function(item) {
            item.removeEventListener('dragstart', handleDragStart, false);
            item.removeEventListener('dragover', handleDragOver, false);
            item.removeEventListener('drop', handleDrop, false);
            item.removeEventListener('dragend', handleDragEnd, false);
         });
         
         items.forEach(function(item) {
            item.addEventListener('dragstart', handleDragStart, false);
            item.addEventListener('dragover', handleDragOver, false);
            item.addEventListener('drop', handleDrop, false);
            item.addEventListener('dragend', handleDragEnd, false);
         });
      };
      
   });
}

function ShowSwalInsertVideoFr()
{
   
   console.log('ESTE ES EL VIDEO');
   
   Swal.fire({
      input: 'text',
      inputLabel: lang_type_video,
      inputPlaceholder: lang_enter_url_video,
      inputAttributes: {
         'aria-label': lang_enter_url_video
      },
      showCancelButton: true
   }).then((result) => {
      
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_video_url_required, 'error');
         return;
      }
      
      let isYoutube = false;
      
      if(result.value.indexOf('https://www.youtube.com/watch?v=') == -1)
      {
         //Validar si es una url que contiene al final la extensión del video
         let url = result.value.split('/');
         let url_last = url[url.length - 1];
         let url_last_split = url_last.split('.');
         let url_last_split_last = url_last_split[url_last_split.length - 1];
         if(url_last_split_last == 'mp4' || url_last_split_last == 'webm' || url_last_split_last == 'ogg')
         {
            isYoutube = false;
         }
         else
         {
            toast(lang_invalid_url, 'error');
            return;
         }
      }
      else{
         isYoutube = true;
      }
      
      let html;
      
      if(isYoutube){
         let video_id = result.value.split('=')[1].split('&')[0];
         let url = 'https://www.youtube.com/watch?v='+video_id;
         html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<img id="'+url+'" src="https://img.youtube.com/vi/'+video_id+'/0.jpg" class="img-fluid video-new" draggable="false"></img>';
         html += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" width="96px" height="96px" class="svg-youtube"><path fill="#FF3D00" d="M43.2,33.9c-0.4,2.1-2.1,3.7-4.2,4c-3.3,0.5-8.8,1.1-15,1.1c-6.1,0-11.6-0.6-15-1.1c-2.1-0.3-3.8-1.9-4.2-4C4.4,31.6,4,28.2,4,24c0-4.2,0.4-7.6,0.8-9.9c0.4-2.1,2.1-3.7,4.2-4C12.3,9.6,17.8,9,24,9c6.2,0,11.6,0.6,15,1.1c2.1,0.3,3.8,1.9,4.2,4c0.4,2.3,0.9,5.7,0.9,9.9C44,28.2,43.6,31.6,43.2,33.9z"></path><path fill="#FFF" d="M20 31L20 17 32 24z"></path></svg>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }else{
         html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<video class="video-new" src="'+result.value+'" controls></video>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }
      
      document.getElementById('section-fr').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-fr');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
   });
   
}

function ShowSwalInsertTextAr()
{
   
   $('#modal-edit-notice').modal('hide');
   $('#modal-insert-text').modal('show');
   $('#text-insert-hidden').val('ar-register');
   
   $('#text-insert').val('');
   $('#text-insert').focus();
   
   //Fix scroll
   $('.modal').css('overflow-y', 'hidden');
   
   return;  
   
}

function ShowSwalInsertImageAr()
{
   
   Swal.fire({
      input: 'file',
      inputLabel: lang_image,
      inputPlaceholder: lang_image_input,
      inputAttributes: {
         'aria-label': lang_image_input
      },
      showCancelButton: true
   }).then((result) => {
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_image_required, 'error');
         return;
      }
      
      let file = result.value;
      let file_type = file.type;
      let valid_image = ['image/jpeg', 'image/png', 'image/jpg'];
      if(valid_image.indexOf(file_type) == -1)
      {
         toast(lang_type_image_required, 'error');
         return;
      }
      
      let reader = new FileReader();
      reader.readAsDataURL(result.value);         
      
      reader.onload = function () {
         
         //validar tamaño de la imagen
         
         if(reader.result.length > 200000){
            toast(lang_image_size_required, 'error');
            return;
         }
         
         let html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span>';
         html += '<img src="'+reader.result+'" class="img-fluid img-new" draggable="false"></img>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         
         document.getElementById('section-ar').innerHTML += html;
         
         let items = document.querySelectorAll('.row-drag-ar');
         
         items.forEach(function(item) {
            item.removeEventListener('dragstart', handleDragStart, false);
            item.removeEventListener('dragover', handleDragOver, false);
            item.removeEventListener('drop', handleDrop, false);
            item.removeEventListener('dragend', handleDragEnd, false);
         });
         
         items.forEach(function(item) {
            item.addEventListener('dragstart', handleDragStart, false);
            item.addEventListener('dragover', handleDragOver, false);
            item.addEventListener('drop', handleDrop, false);
            item.addEventListener('dragend', handleDragEnd, false);
         });
      };
      
   });
   
}

function ShowSwalInsertVideoAr()
{
   console.log('Este es el video 2');
   
   Swal.fire({
      input: 'text',
      inputLabel: lang_type_video,
      inputPlaceholder: lang_enter_url_video,
      inputAttributes: {
         'aria-label': lang_enter_url_video
      },
      showCancelButton: true
   }).then((result) => {
      
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_video_url_required, 'error');
         return;
      }
      
      let isYoutube = false;
      
      if(result.value.indexOf('https://www.youtube.com/watch?v=') == -1)
      {
         //Validar si es una url que contiene al final la extensión del video
         let url = result.value.split('/');
         let url_last = url[url.length - 1];
         let url_last_split = url_last.split('.');
         let url_last_split_last = url_last_split[url_last_split.length - 1];
         if(url_last_split_last == 'mp4' || url_last_split_last == 'webm' || url_last_split_last == 'ogg')
         {
            isYoutube = false;
         }
         else
         {
            toast(lang_invalid_url, 'error');
            return;
         }
      }
      else{
         isYoutube = true;
      }
      
      let html;
      
      if(isYoutube){
         let video_id = result.value.split('=')[1].split('&')[0];
         let url = 'https://www.youtube.com/watch?v='+video_id;
         html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<img id="'+url+'" src="https://img.youtube.com/vi/'+video_id+'/0.jpg" class="img-fluid video-new" draggable="false"></img>';
         html += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" width="96px" height="96px" class="svg-youtube"><path fill="#FF3D00" d="M43.2,33.9c-0.4,2.1-2.1,3.7-4.2,4c-3.3,0.5-8.8,1.1-15,1.1c-6.1,0-11.6-0.6-15-1.1c-2.1-0.3-3.8-1.9-4.2-4C4.4,31.6,4,28.2,4,24c0-4.2,0.4-7.6,0.8-9.9c0.4-2.1,2.1-3.7,4.2-4C12.3,9.6,17.8,9,24,9c6.2,0,11.6,0.6,15,1.1c2.1,0.3,3.8,1.9,4.2,4c0.4,2.3,0.9,5.7,0.9,9.9C44,28.2,43.6,31.6,43.2,33.9z"></path><path fill="#FFF" d="M20 31L20 17 32 24z"></path></svg>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }else{
         html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<video class="video-new" src="'+result.value+'" controls></video>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }
      
      document.getElementById('section-ar').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-ar');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
   });
   
}

function ModalShowSwalInsertTextAr()
{
   
   $('#modal-edit-notice').modal('hide');
   $('#modal-insert-text').modal('show');
   $('#text-insert-hidden').val('ar-modal');
   
   $('#text-insert').val('');
   $('#text-insert').focus();
   
   //Fix scroll
   $('.modal').css('overflow-y', 'hidden');
   
   return;   
}

function ModalShowSwalInsertImageAr()
{
   
   $('#modal-edit-notice').modal('hide');
   Swal.fire({
      input: 'file',
      inputLabel: lang_image,
      inputPlaceholder: lang_image_input,
      inputAttributes: {
         'aria-label': lang_image_input
      },
      showCancelButton: true
   }).then((result) => {
      $('#modal-edit-notice').modal('show');
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_image_required, 'error');
         return;
      }
      
      let file = result.value;
      let file_type = file.type;
      let valid_image = ['image/jpeg', 'image/png', 'image/jpg'];
      if(valid_image.indexOf(file_type) == -1)
      {
         toast(lang_type_image_required, 'error');
         return;
      }
      
      let reader = new FileReader();
      reader.readAsDataURL(result.value);         
      
      reader.onload = function () {
         
         //validar tamaño de la imagen
         
         if(reader.result.length > 200000){
            toast(lang_image_size_required, 'error');
            return;
         }
         
         let html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span>';
         html += '<img src="'+reader.result+'" class="img-fluid img-new" draggable="false"></img>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         
         document.getElementById('modal-section-ar').innerHTML += html;
         
         let items = document.querySelectorAll('.row-drag-ar');
         
         items.forEach(function(item) {
            item.removeEventListener('dragstart', handleDragStart, false);
            item.removeEventListener('dragover', handleDragOver, false);
            item.removeEventListener('drop', handleDrop, false);
            item.removeEventListener('dragend', handleDragEnd, false);
         });
         
         items.forEach(function(item) {
            item.addEventListener('dragstart', handleDragStart, false);
            item.addEventListener('dragover', handleDragOver, false);
            item.addEventListener('drop', handleDrop, false);
            item.addEventListener('dragend', handleDragEnd, false);
         });
      };
      
   });
   
}

function ModalShowSwalInsertVideoAr()
{
   //Ocultar modal
   $('#modal-edit-notice').modal('hide');
   
   Swal.fire({
      input: 'text',
      inputLabel: lang_type_video,
      inputPlaceholder: lang_enter_url_video,
      inputAttributes: {
         'aria-label': lang_enter_url_video
      },
      showCancelButton: true
   }).then((result) => {
      
      $('#modal-edit-notice').modal('show');
      
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_video_url_required, 'error');
         return;
      }
      
      let isYoutube = false;
      
      if(result.value.indexOf('https://www.youtube.com/watch?v=') == -1)
      {
         //Validar si es una url que contiene al final la extensión del video
         let url = result.value.split('/');
         let url_last = url[url.length - 1];
         let url_last_split = url_last.split('.');
         let url_last_split_last = url_last_split[url_last_split.length - 1];
         if(url_last_split_last == 'mp4' || url_last_split_last == 'webm' || url_last_split_last == 'ogg')
         {
            isYoutube = false;
         }
         else
         {
            toast(lang_invalid_url, 'error');
            return;
         }
      }
      else{
         isYoutube = true;
      }
      
      let html;
      
      if(isYoutube){
         let video_id = result.value.split('=')[1].split('&')[0];
         let url = 'https://www.youtube.com/watch?v='+video_id;
         html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<img id="'+url+'" src="https://img.youtube.com/vi/'+video_id+'/0.jpg" class="img-fluid video-new" draggable="false"></img>';
         html += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" width="96px" height="96px" class="svg-youtube"><path fill="#FF3D00" d="M43.2,33.9c-0.4,2.1-2.1,3.7-4.2,4c-3.3,0.5-8.8,1.1-15,1.1c-6.1,0-11.6-0.6-15-1.1c-2.1-0.3-3.8-1.9-4.2-4C4.4,31.6,4,28.2,4,24c0-4.2,0.4-7.6,0.8-9.9c0.4-2.1,2.1-3.7,4.2-4C12.3,9.6,17.8,9,24,9c6.2,0,11.6,0.6,15,1.1c2.1,0.3,3.8,1.9,4.2,4c0.4,2.3,0.9,5.7,0.9,9.9C44,28.2,43.6,31.6,43.2,33.9z"></path><path fill="#FFF" d="M20 31L20 17 32 24z"></path></svg>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }else{
         html = '<div class="row row-drag-ar" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<video class="video-new" src="'+result.value+'" controls></video>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }
      
      document.getElementById('modal-section-ar').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-ar');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
   });
   
}

function ModalShowSwalInsertVideoServerFr()
{
   $('#modal-edit-notice').modal('hide');
   
   $('#modal-upload-video').modal('show');
   
   $('#register-file-server').val('');
   
   row_id = 'row row-drag-fr';
   modal_section = 'modal-section-fr';
   row_drag = '.row-drag-fr';
   modal_enabled = true;
   
   return;
}

function ModalShowSwalInsertVideoServerAr()
{
   $('#modal-edit-notice').modal('hide');
   
   $('#modal-upload-video').modal('show');
   
   $('#register-file-server').val('');
   
   row_id = 'row row-drag-ar';
   modal_section = 'modal-section-ar';
   row_drag = '.row-drag-ar';
   modal_enabled = true
   
   return;
}

function ShowSwalInsertVideoServerFr()
{
   $('#modal-upload-video').modal('show');
   
   $('#register-file-server').val('');
   
   row_id = 'row row-drag-fr';
   modal_section = 'section-fr';
   row_drag = '.row-drag-fr';
   modal_enabled = false;
   
   return;
}


function ShowSwalInsertVideoServerAr()
{
   $('#modal-upload-video').modal('show');
   
   $('#register-file-server').val('');
   
   row_id = 'row row-drag-ar';
   modal_section = 'section-ar';
   row_drag = '.row-drag-ar';
   modal_enabled = false;
   
   return;
}

function UploadVideoServer(){
   
   let file = document.getElementById('register-file-server').files[0];
   
   if(file == undefined || file == null || file == '')
   {
      toast(lang_video_required, 'error');
      return;
   }
   
   let formData = new FormData();
   formData.append('video', file);
   formData.append('language', language);
   
   $('#modal-upload-video').modal({backdrop: 'static', keyboard: false});
   $('#progress_bar_upload_file').css('display', 'block');
   
   $.ajax({
      url: 'api/notice/upload/video',
      type: 'POST',
      data: formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      enctype: 'multipart/form-data',
      success: function(response){
         if(response.status) {
            let html = '<div class="'+row_id+'" draggable="true">';
            html += '<div class="col-12 col-drag">';
            html += '<div class="card text-white section-drag">';
            html += '<div class="card-body card-drag">';
            html += '<div class="card-content-drag">';
            html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
            html += '<span class="container-video">';
            html += '<video class="video-new" src="'+response.path+'" controls></video>';
            html += '</span>';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            html += '</div>';
            
            $('#modal-upload-video').modal('hide');
            
            if(modal_enabled){
               $('#modal-edit-notice').modal('show');
            }
            
            $('#progress_bar_upload_file').css('display', 'none');
            
            $('.modal').css('overflow-y', 'auto');
            
            document.getElementById(modal_section).innerHTML += html;
            let items = document.querySelectorAll(row_drag);
            
            items.forEach(function(item) {
               item.removeEventListener('dragstart', handleDragStart, false);
               item.removeEventListener('dragover', handleDragOver, false);
               item.removeEventListener('drop', handleDrop, false);
               item.removeEventListener('dragend', handleDragEnd, false);
            });
            items.forEach(function(item) {
               item.addEventListener('dragstart', handleDragStart, false);
               item.addEventListener('dragover', handleDragOver, false);
               item.addEventListener('drop', handleDrop, false);
               item.addEventListener('dragend', handleDragEnd, false);
            });
            
         }else{
            toast(response.message, 'error');
         }
         
      },
      //progress
      xhr: function() {
         let xhr = new window.XMLHttpRequest();
         xhr.upload.addEventListener("progress", function(evt) {
            if (evt.lengthComputable) {
               let percentComplete = evt.loaded / evt.total;
               percentComplete = parseInt(percentComplete * 100);
               $('#progress_bar_upload_file').css('width', percentComplete + '%');
               $('#progress_bar_upload_file').html(percentComplete + '%');
            }
         }, false);
         return xhr;
      },
      error: function (response) {
         
         if(response.status == 413){
            toast(lang_video_max_size, 'error');
         }
         else{
            toast(response.message, 'error');
         }
         $('#progress_bar_upload_file').css('display', 'none');
      }
   });
   
}

function RegisterServerVideo()
{
   $('#modal-upload-video-principal').modal('show');
   $('#register-file-server-principal').val('');
   register_url_video_principal = true;
   return;
}

function ModalRegisterServerVideo()
{
   $('#modal-edit-notice').modal('hide');
   $('#modal-upload-video-principal').modal('show');
   $('#register-file-server-principal').val('');
   register_url_video_principal = false;
   return;
}

function UploadVideoServerPrincipal(){
   
   let file = document.getElementById('register-file-server-principal').files[0];
   
   if(file == undefined || file == null || file == '')
   {
      toast(lang_video_required, 'error');
      return;
   }
   
   let formData = new FormData();
   formData.append('video', file);
   formData.append('language', language);
   
   $('#modal-upload-video-principal').modal({backdrop: 'static', keyboard: false});
   $('#progress_bar_upload_file_principal').css('display', 'block');
   
   $.ajax({
      url: 'api/notice/upload/video',
      type: 'POST',
      data: formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      enctype: 'multipart/form-data',
      success: function(response){
         if(response.status) {
            
            $('#modal-upload-video-principal').modal('hide');
            $('#progress_bar_upload_file_principal').css('display', 'none');
            $('.modal').css('overflow-y', 'auto');
            
            if(register_url_video_principal){
               $('#url_video').val(response.path);
            }else{
               $('#modal-edit-notice').modal('show');
               $('#modal_url_video').val(response.path);
            }
            
         }else{
            toast(response.message, 'error');
         }
         
      },
      //progress
      xhr: function() {
         let xhr = new window.XMLHttpRequest();
         xhr.upload.addEventListener("progress", function(evt) {
            if (evt.lengthComputable) {
               let percentComplete = evt.loaded / evt.total;
               percentComplete = parseInt(percentComplete * 100);
               $('#progress_bar_upload_file').css('width', percentComplete + '%');
               $('#progress_bar_upload_file').html(percentComplete + '%');
            }
         }, false);
         return xhr;
      },
      error: function (response) {
         
         if(response.status == 413){
            toast(lang_video_max_size, 'error');
         }
         else{
            toast(response.message, 'error');
         }
         $('#progress_bar_upload_file_principal').css('display', 'none');
      }
   });
   
}

function ModalShowSwalInsertTextFr()
{
   
   $('#modal-edit-notice').modal('hide');
   $('#modal-insert-text').modal('show');
   $('#text-insert-hidden').val('fr-modal');
   
   $('#text-insert').val('');
   $('#text-insert').focus();
   
   //Fix scroll
   $('.modal').css('overflow-y', 'hidden');
   
   return;   
}

function CancelRegisterInDiv(){
   
   $('#modal-insert-text').modal('hide');
   let section = document.getElementById('text-insert-hidden').value;
   
   if(section == 'fr-modal' || section == 'ar-modal'){
      $('#modal-edit-notice').modal('show');
   }else{
      //Nothing
   }
   
   //Fix scroll
   $('.modal').css('overflow-y', 'auto');
   
   return;
}

function RegisterInDiv(){
   
   let text = document.getElementById('text-insert').value;
   let section = document.getElementById('text-insert-hidden').value;
   
   if(text == '' || text == null || text == undefined){
      toast(lang_text_required, 'error');
      return;
   }
   
   text = text.trim();
   
   if(section == 'fr-modal'){
      
      //Obtener el ultimo id
      let last_id = 0;
      let last_id_element = document.getElementById('modal-section-fr').childElementCount;
      
      let html = '<div class="row row-drag-fr" draggable="true" id="modal-row-fr-'+last_id_element+'">';
      html += '<div class="col-12 col-drag">';
      html += '<div class="card bg-info text-white section-drag">';
      html += '<div class="card-body card-drag">';
      html += '<div class="card-content-drag">';
      html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
      html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
      html += '<span>';
      html += '<p class="text-new">'+text+'</p>';
      html += '</span>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      
      document.getElementById('modal-section-fr').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-fr');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
      $('#modal-edit-notice').modal('show');
      $('#modal-insert-text').modal('hide');
      
   }
   else if(section == 'ar-modal'){
      
      //Obtener el ultimo id
      let last_id = 0;
      let last_id_element = document.getElementById('modal-section-ar').childElementCount;
      
      let html = '<div class="row row-drag-ar" draggable="true" id="modal-row-ar-'+last_id_element+'">';
      html += '<div class="col-12 col-drag">';
      html += '<div class="card bg-info text-white section-drag">';
      html += '<div class="card-body card-drag">';
      html += '<div class="card-content-drag">';
      html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
      html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
      html += '<span>';
      html += '<p class="text-new">'+text+'</p>';
      html += '</span>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      
      document.getElementById('modal-section-ar').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-ar');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
      $('#modal-edit-notice').modal('show');
      $('#modal-insert-text').modal('hide');
      
   }else if (section == 'fr-register'){
      
      //Obtener el ultimo id
      let last_id = 0;
      let last_id_element = document.getElementById('section-fr').childElementCount;
      
      let html = '<div class="row row-drag-fr" draggable="true" id="row-fr-'+last_id_element+'">';
      html += '<div class="col-12 col-drag">';
      html += '<div class="card bg-info text-white section-drag">';
      html += '<div class="card-body card-drag">';
      html += '<div class="card-content-drag">';
      html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
      html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
      html += '<span>';
      html += '<p class="text-new">'+text+'</p>';
      html += '</span>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      
      document.getElementById('section-fr').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-fr');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
      $('#modal-insert-text').modal('hide');
      
   }else if (section == 'ar-register'){
      
      //Obtener el ultimo id
      let last_id = 0;
      let last_id_element = document.getElementById('section-ar').childElementCount;
      
      let html = '<div class="row row-drag-ar" draggable="true" id="row-ar-'+last_id_element+'">';
      html += '<div class="col-12 col-drag">';
      html += '<div class="card bg-info text-white section-drag">';
      html += '<div class="card-body card-drag">';
      html += '<div class="card-content-drag">';
      html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
      html += '<button class="btn btn-edit-div" onclick="EditDiv(this)"><i class="fa-solid fa-edit"></i></button>';
      html += '<span>';
      html += '<p class="text-new">'+text+'</p>';
      html += '</span>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      html += '</div>';
      
      document.getElementById('section-ar').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-ar');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
      $('#modal-insert-text').modal('hide');
      
   }
   
   
   //Fix scroll
   $('.modal').css('overflow-y', 'auto');
   
   //Clear text
   $('#text-insert').val('');
   
}

function EditDiv(element)
{
   let identificador = element.parentNode.parentNode.parentNode.parentNode.parentNode.parentNode.id;
   let childElement = element.parentNode.parentNode.parentNode.parentNode.parentNode;
   let index = childElement.id;
   let content = element.parentNode.textContent;
   
   btn_edit_test = element;
   
   if (identificador == 'modal-section-fr') {
      $('#modal-edit-text').modal('show');
      $('#modal-edit-notice').modal('hide');
      $('#text-edit').val(content);
      $('#text-child-hidden').val(index);
      $('#text-parent-hidden').val(identificador);
   }else if (identificador == 'modal-section-ar') {
      $('#modal-edit-text').modal('show');
      $('#modal-edit-notice').modal('hide');
      $('#text-edit').val(content);
      $('#text-child-hidden').val(index);
      $('#text-parent-hidden').val(identificador);
   }else if (identificador == 'section-fr') {
      $('#modal-edit-text').modal('show');
      $('#text-edit').val(content);
      $('#text-child-hidden').val(index);
      $('#text-parent-hidden').val(identificador);
   }else if (identificador == 'section-ar') {
      $('#modal-edit-text').modal('show');
      $('#text-edit').val(content);
      $('#text-child-hidden').val(index);
      $('#text-parent-hidden').val(identificador);
   }
}

function EditInDiv(){
   
   let text = $('#text-edit').val();
   let childElement = $('#text-child-hidden').val();
   let identificador = $('#text-parent-hidden').val();
   
   console.log(text);
   console.log(childElement);
   console.log(identificador);
   
   $('#modal-edit-text').modal('hide');
   
   if (identificador == 'modal-section-fr') {
      $('#modal-edit-notice').modal('show');
      document.getElementById(childElement).childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
      //document.getElementById('modal-section-fr').childNodes[childElement].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
   }else if (identificador == 'modal-section-ar'){
      $('#modal-edit-notice').modal('show');
      document.getElementById(childElement).childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
      //document.getElementById('modal-section-ar').childNodes[childElement].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
   }else if (identificador == 'section-fr'){
      document.getElementById(childElement).childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
      //document.getElementById('section-fr').childNodes[childElement].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
   }else if (identificador == 'section-ar'){
      document.getElementById(childElement).childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
      //document.getElementById('section-ar').childNodes[childElement].childNodes[0].childNodes[0].childNodes[0].childNodes[0].childNodes[2].innerHTML = '<p class="text-new">'+text+'</p>';
   }
   
   $('.modal').css('overflow-y', 'auto');
   
}

function CancelEditInDiv(){
   
   $('#modal-edit-text').modal('hide');
   
   let identificador = $('#text-parent-hidden').val();
   
   if(identificador == 'modal-section-fr' || identificador == 'modal-section-ar'){
      $('#modal-edit-notice').modal('show');
   }
   
   //Fix scroll
   $('.modal').css('overflow-y', 'auto');
   
   return;
}

function ModalShowSwalInsertImageFr()
{
   $('#modal-edit-notice').modal('hide');
   Swal.fire({
      input: 'file',
      inputLabel: lang_image,
      inputPlaceholder: lang_image_input,
      inputAttributes: {
         'aria-label': lang_image_input
      },
      showCancelButton: true
   }).then((result) => {
      $('#modal-edit-notice').modal('show');
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_image_required, 'error');
         return;
      }
      
      let file = result.value;
      let file_type = file.type;
      let valid_image = ['image/jpeg', 'image/png', 'image/jpg'];
      if(valid_image.indexOf(file_type) == -1)
      {
         toast(lang_type_image_required, 'error');
         return;
      }
      
      let reader = new FileReader();
      reader.readAsDataURL(result.value);
      reader.onload = function () {
         let html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span>';
         html += '<img src="'+reader.result+'" class="img-fluid img-new" draggable="false"></img>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         
         document.getElementById('modal-section-fr').innerHTML += html;
         
         let items = document.querySelectorAll('.row-drag-fr');
         
         items.forEach(function(item) {
            item.removeEventListener('dragstart', handleDragStart, false);
            item.removeEventListener('dragover', handleDragOver, false);
            item.removeEventListener('drop', handleDrop, false);
            item.removeEventListener('dragend', handleDragEnd, false);
         });
         
         items.forEach(function(item) {
            item.addEventListener('dragstart', handleDragStart, false);
            item.addEventListener('dragover', handleDragOver, false);
            item.addEventListener('drop', handleDrop, false);
            item.addEventListener('dragend', handleDragEnd, false);
         });
      };
      
   });
}

function ModalShowSwalInsertVideoFr()
{
   $('#modal-edit-notice').modal('hide');
   Swal.fire({
      input: 'text',
      inputLabel: lang_type_video,
      inputPlaceholder: lang_enter_url_video,
      inputAttributes: {
         'aria-label': lang_enter_url_video
      },
      showCancelButton: true
   }).then((result) => {
      $('#modal-edit-notice').modal('show');
      if(result.value == '' || result.value == null || result.value == undefined)
      {
         toast(lang_video_url_required, 'error');
         return;
      }
      
      if(result.value.indexOf('https://www.youtube.com/watch?v=') == -1)
      {
         //Validar si es una url que contiene al final la extensión del video
         let url = result.value.split('/');
         let url_last = url[url.length - 1];
         let url_last_split = url_last.split('.');
         let url_last_split_last = url_last_split[url_last_split.length - 1];
         if(url_last_split_last == 'mp4' || url_last_split_last == 'webm' || url_last_split_last == 'ogg')
         {
            isYoutube = false;
         }
         else
         {
            toast(lang_invalid_url, 'error');
            return;
         }
      }
      else{
         isYoutube = true;
      }
      
      let html;
      
      
      if(isYoutube){
         let video_id = result.value.split('=')[1].split('&')[0];
         let url = 'https://www.youtube.com/watch?v='+video_id;
         html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<img id="'+url+'" src="https://img.youtube.com/vi/'+video_id+'/0.jpg" class="img-fluid video-new" draggable="false"></img>';
         html += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" width="96px" height="96px" class="svg-youtube"><path fill="#FF3D00" d="M43.2,33.9c-0.4,2.1-2.1,3.7-4.2,4c-3.3,0.5-8.8,1.1-15,1.1c-6.1,0-11.6-0.6-15-1.1c-2.1-0.3-3.8-1.9-4.2-4C4.4,31.6,4,28.2,4,24c0-4.2,0.4-7.6,0.8-9.9c0.4-2.1,2.1-3.7,4.2-4C12.3,9.6,17.8,9,24,9c6.2,0,11.6,0.6,15,1.1c2.1,0.3,3.8,1.9,4.2,4c0.4,2.3,0.9,5.7,0.9,9.9C44,28.2,43.6,31.6,43.2,33.9z"></path><path fill="#FFF" d="M20 31L20 17 32 24z"></path></svg>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }else{
         html = '<div class="row row-drag-fr" draggable="true">';
         html += '<div class="col-12 col-drag">';
         html += '<div class="card text-white section-drag">';
         html += '<div class="card-body card-drag">';
         html += '<div class="card-content-drag">';
         html += '<button class="btn btn-delete-div" onclick="RemoveDiv(this)"><i class="fa-solid fa-trash"></i></i></button>';
         html += '<span class="container-video">';
         html += '<video class="video-new" src="'+result.value+'" controls></video>';
         html += '</span>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
         html += '</div>';
      }
      
      document.getElementById('modal-section-fr').innerHTML += html;
      
      let items = document.querySelectorAll('.row-drag-fr');
      
      items.forEach(function(item) {
         item.removeEventListener('dragstart', handleDragStart, false);
         item.removeEventListener('dragover', handleDragOver, false);
         item.removeEventListener('drop', handleDrop, false);
         item.removeEventListener('dragend', handleDragEnd, false);
      });
      
      items.forEach(function(item) {
         item.addEventListener('dragstart', handleDragStart, false);
         item.addEventListener('dragover', handleDragOver, false);
         item.addEventListener('drop', handleDrop, false);
         item.addEventListener('dragend', handleDragEnd, false);
      });
      
   });
   
}


function handleDragStart(e) {
   this.style.opacity = '0.4';
   
   dragSrcEl = this;
   
   e.dataTransfer.effectAllowed = 'move';
   e.dataTransfer.setData('text/html', this.innerHTML);
}

function handleDragOver(e) {        
   if (e.preventDefault) {
      e.preventDefault();
   }
   
   e.dataTransfer.dropEffect = 'move';
   
   return false;
}

function handleDragEnter(e) {        
   items.forEach(function (item) {
      item.classList.remove('over');
   });
   
   this.classList.add('over');
}

function handleDragLeave(e) {
   this.classList.remove('over');
}

function handleDrop(e) {
   if (e.stopPropagation) {
      e.stopPropagation();
   }
   
   if (dragSrcEl != this) {
      dragSrcEl.innerHTML = this.innerHTML;
      this.innerHTML = e.dataTransfer.getData('text/html');
   }
   
   return false;
}

function handleDragEnd(e) {
   console.log('handleDragEnd');
   
   this.style.opacity = '1';
   
   let items_ar = document.querySelectorAll('.row-drag-ar');
   items_ar.forEach(function (item) {
      item.classList.remove('over');
   });
   
   let items_fr = document.querySelectorAll('.row-drag-fr');
   items_fr.forEach(function (item) {
      item.classList.remove('over');
   });
}

function getQuillData(quill) {
   var html = quill.root.innerHTML.trim();
   return html;
}

function clearQuillData(quill) {
   quill.root.innerHTML = '';
}

function setQuillData(quill, html) {
   quill.root.innerHTML = html;
}

$(document).ready(function() {
   
   /*quil_title_ara = new Quill('#quill_title_ara', {
      modules: {
         toolbar: toolbarOptions
      },
      theme: 'snow'
   });
   
   quil_title_fr = new Quill('#quill_title_fr', {
      modules: {
         toolbar: toolbarOptions
      },
      theme: 'snow'
   });
   
   
   quil_modal_title_ara = new Quill('#quill_modal_title_ara', {
      modules: {
         toolbar: toolbarOptions
      },
      theme: 'snow'
   });
   
   quil_modal_title_fr = new Quill('#quill_modal_title_fr', {
      modules: {
         toolbar: toolbarOptions
      },
      theme: 'snow'
   });
   */
   
   LoadCategoriesOptions();
   LoadCategories();
   
   $('#btn-save-notice').click(function() {
      RegisterNotice();
   });
   
   $('#btn-insert-text-fr').click(function() {
      ShowSwalInsertTextFr();
   });
   
   $('#btn-insert-image-fr').click(function() {
      ShowSwalInsertImageFr();
   });
   
   $('#btn-insert-video-fr').click(function() {
      ShowSwalInsertVideoFr();
   });
   
   $('#btn-insert-text-ar').click(function() {
      ShowSwalInsertTextAr();
   });
   
   $('#btn-insert-image-ar').click(function() {
      ShowSwalInsertImageAr();
   });
   
   $('#btn-insert-video-ar').click(function() {
      ShowSwalInsertVideoAr();
   });
   
   //
   
   $('#modal-btn-insert-text-fr').click(function() {
      ModalShowSwalInsertTextFr();
   });
   
   $('#modal-btn-insert-image-fr').click(function() {
      ModalShowSwalInsertImageFr();
   });
   
   $('#modal-btn-insert-video-fr').click(function() {
      ModalShowSwalInsertVideoFr();
   });
   
   $('#modal-btn-insert-text-ar').click(function() {
      ModalShowSwalInsertTextAr();
   });
   
   $('#modal-btn-insert-image-ar').click(function() {
      ModalShowSwalInsertImageAr();
   });
   
   $('#modal-btn-insert-video-ar').click(function() {
      ModalShowSwalInsertVideoAr();
   });
   
   $('#modal-btn-insert-video-server-fr').click(function() {
      ModalShowSwalInsertVideoServerFr();
   });
   
   $('#modal-btn-insert-video-server-ar').click(function() {
      ModalShowSwalInsertVideoServerAr();
   });
   
   $('#modal-btn-insert-video-server').click(function() {
      ModalRegisterServerVideo();
   });
   
   $('#btn-insert-video-server').click(function() {
      RegisterServerVideo();
   });
   
   
   /**btn-insert-video-server-ar
   btn-insert-video-server-ar */
   
   $('#btn-insert-video-server-fr').click(function() {
      ShowSwalInsertVideoServerFr();
   });
   
   $('#btn-insert-video-server-ar').click(function() {
      ShowSwalInsertVideoServerAr();
   });
   
   $('#type').on('change', function() {
      if($(this).val() == 'video'){
         $('#url_video_div').show();
      }else{
         $('#url_video_div').hide();
      }
   });
   
   if($('#type').val() == 'video'){
      $('#url_video_div').show();
   }else{
      $('#url_video_div').hide();
   }
   
   $('#type').on('change', function() {
      if($(this).val() == 'video'){
         $('#url_video_div').show();
      }else{
         $('#url_video_div').hide();
      }
   });
   
   $('#modal_type').on('change', function() {
      if($(this).val() == 'video'){
         $('#modal_url_video_div').show();
      }else{
         $('#modal_url_video_div').hide();
      }
   });
   
   $('.btn-up').on('click', function() {
      console.log('You clicked up button');
      let parent = $(this).parent().parent();
      let prev = parent.prev();
      if(prev.length > 0) {
         parent.insertBefore(prev);
      }
   });
   
   $('.btn-down').on('click', function() {
      console.log('You clicked down button');
      let parent = $(this).parent().parent();
      let next = parent.next();
      if(next.length > 0) {
         parent.insertAfter(next);
      }
   });
   
});