function LoadLastNotices(){
   let data =
   {
      language: language
   };
   
   $.ajax({
      url: 'api/notice/get/last/three',
      data: data,
      type: 'POST',
      dataType: 'json',
      success: function(response){
         if(response.status){
            var html = '';
            $.each(response.data, function(key, value){
               html += '<div class="list-group-item list-group-item-action" href="#">';
               html += '<div class="media mt-0">';
               html += '<img class="avatar-lg rounded-circle my-auto me-3" src="'+value.image+'">';
               html += '<div class="media-body">';
               html += '<div class="d-flex align-items-center">';
               html += '<div class="mt-0">';
               if(language == 'ar'){
                  html += '<h5 class="mb-1 tx-15">'+value.title_ara.substring(0, 25) + '...';+'</h5>';
               }else{
                  html += '<h5 class="mb-1 tx-15">'+value.title_fr.substring(0, 25) + '...';+'</h5>';
               }
               if(language == 'ar'){
                  html += '<p class="mb-0 tx-13 text-muted">'+value.date_ar+'</p>';
               }else{
                  html += '<p class="mb-0 tx-13 text-muted">'+value.date_fr+'</p>';
               }
               html += '</div>';
               html += '<span class="ms-auto wd-45p fs-16 mt-2">';
               html += '<div id="spark1" class="wd-100p">';
               html += '<i class="'+value.category_icon+'"></i>  ';
               if(language == 'ar'){
                  html += value.category_name_ara;
               }else{
                  html += value.category_name_fr;
               }
               html += '</div>';
               html += '</span>';
               html += '</div>';
               html += '</div>';
               html += '</div>';
               html += '</div>';
            });
            
            $('#container-notices-card').html(html);
         }
         else
         {
            console.log(response.message);
         }
      },
      error: function(data){
         console.log(data);
      }
   });
}

function GetStatsNotices(){
   let data =
   {
      language: language
   }
   
   $.ajax({
      data: data,
      url: 'api/notice/get/stats',
      type: 'POST',
      dataType: 'json',
      success: function(response){
         if(response.status){
            $('#total-notices').html(response.data.total);            
         }else{
            console.log(response.message);
         }
      },
      error: function(data){
         console.log(data);
      }
   });
}

function GetStatsCategory(){
   let data =
   {
      language: language
   }
   
   $.ajax({
      data: data,
      url: 'api/notice/get/stats/categories',
      type: 'POST',
      dataType: 'json',
      success: function(response){
         if(response.status){
            console.log(response);
            $('#most-category').html(response.data.total);
         }else{
            console.log(response.message);
         }
      },
      error: function(data){
         console.log(data);
      }
   });
}

function LoadCategories()
{
   let data = {
      language: language,
      status: 'true'
   };
   
   $.ajax({
      data: data,
      url: 'api/category/get/last/register/with/count/notices',
      type: 'POST',
      success: function(response) {
         if(response.status)
         {
            var html = '';
            $.each(response.data, function(key, value){
               html += '<ul class="timeline-1 mb-0">';
               html += '<li class="mt-0" id="mrg-8">';
               html += '<i class="'+value.icon+' bg-primary-gradient text-white product-icon"></i>';
               if(language == 'ar'){
                  html += '<span class="fw-semibold mb-4 tx-14" id="category_name">'+value.name_ara+'</span>';
                  html += '<a href="#" class="float-end tx-11 text-muted" id="category_date">'+value.date_ar+'</a>';
               }else{
                  html += '<span class="fw-semibold mb-4 tx-14" id="category_name">'+value.name_fr+'</span>';
                  html += '<a href="#" class="float-end tx-11 text-muted" id="category_date">'+value.date_fr+'</a>';
               }
               html += '<p class="mb-0 text-muted tx-12" id="category_count">'+value.notices_count+'</p>';
               html += '</li>';
               html += '</ul>';
            });
            
            $('#container-category-card').html(html);
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

$(document).ready(function(){
   LoadCategories();
   GetStatsNotices();
   LoadLastNotices();
   GetStatsCategory();
});