var table = null;
var rowReorder = null;

function RegisterCategory()
{
   let name_ara = $('#name_ara').val();
   let name_fr = $('#name_fr').val();
   let status = $('#status').val();
   
   let icons = document.getElementsByName("customRadioInline1");
   let icon = '';
   for(let i = 0; i < icons.length; i++)
   {
      if(icons[i].checked)
      {
         icon = icons[i].nextElementSibling.firstElementChild.className;
      }
   }
   
   let text_color = $("#text_color").spectrum('get').toHex();
   text_color = '#' + text_color;
   
   let icon_color = $("#icon_color").spectrum('get').toHex();
   icon_color = '#' + icon_color;
   
   
   let data = {
      language: language,
      name_ara: name_ara,
      name_fr: name_fr,
      icon: icon,
      text_color: text_color,
      icon_color: icon_color,
      status: status
   };
   
   $.ajax({
      url: 'api/category/register',
      type: 'POST',
      data: data,
      success: function(response) {
         if(response.status) {
            $('#name_ara').val('');
            $('#name_fr').val('');
            $("#icon").val($("#icon option:first").val());
            $('#status').val($('#status option:first').val());
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
   
}

function EditCategoryModal(id)
{
   let data = {
      language: language,
      id: id
   };
   
   $.ajax({
      data: data,
      url: 'api/category/get/id',
      type: 'POST',
      success: function(response) {
         if(response.status)
         {
            let category = response.data;
            $('#modal_name_ara').val(category.name_ara);
            $('#modal_name_fr').val(category.name_fr);
            //ICON
            let icons = document.getElementsByName("customRadioInline2");
            for(let i = 0; i < icons.length; i++)
            {
               if(icons[i].nextElementSibling.firstElementChild.className == category.icon)
               {
                  icons[i].checked = true;
               }
            }
            if(category.status)
            {
               $('#modal_status').val("true");
            }
            else
            {
               $('#modal_status').val("false");
            }
            
            let text_color = category.text_color;
            let icon_color = category.icon_color;
            
            let option_color_text = {
               color: text_color,
               showInput: true,
               showInitial: true,
               preferredFormat: "hex",
               chooseText: lang_chooseText,
               cancelText: lang_cancelText,
               appendTo: '#modal-edit-category'
            }
            
            let option_color_icon = {
               color: icon_color,
               showInput: true,
               showInitial: true,
               preferredFormat: "hex",
               chooseText: lang_chooseText,
               cancelText: lang_cancelText,
               appendTo: '#modal-edit-category'
            }
            
            $("#modal_text_color").spectrum(option_color_text);
            $("#modal_icon_color").spectrum(option_color_icon);
            
            $('#modal_id').val(category.id);
            $('#modal-edit-category').modal('show');
            
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function DeleteCategory(id){
   
   let data = {
      language: language,
      id: id
   };
   
   let title = '';
   let text = '';
   let confirmButtonText = '';
   let cancelButtonText = '';
   
   if(language == 'ar')
   {
      title = 'هل أنت متأكد من حذف هذا الفئة؟';
      text = "!لا يمكنك التراجع عن هذا";
      confirmButtonText = 'نعم، حذف';
      cancelButtonText = 'إلغاء';
   }else{
      //French
      title = 'Êtes-vous sûr de supprimer cette catégorie?';
      text = "!Vous ne pourrez pas revenir en arrière";
      confirmButtonText = 'Oui, supprimer';
      cancelButtonText = 'Annuler';
   }
   
   Swal.fire({
      title: title,
      text: text,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: confirmButtonText,
      cancelButtonText: cancelButtonText
   }).then((result) => {
      if (result.value) {
         $.ajax({
            url: 'api/category/delete',
            type: 'POST',
            data: data,
            success: function(response){
               if(response.status) {
                  table.ajax.reload(null, false);
                  toast(response.message, 'success');
               }else{
                  toast(response.message, 'error');
               }
            },
            error: function(error) {
               console.log(error);
            }
         });
      }
   })
}

function SaveEditCategory()
{
   var id = $('#modal_id').val();
   var name_ara = $('#modal_name_ara').val();
   var name_fr = $('#modal_name_fr').val();
   var status = $('#modal_status').val();
   let icons = document.getElementsByName("customRadioInline2");
   let icon = '';
   for(let i = 0; i < icons.length; i++)
   {
      if(icons[i].checked)
      {
         icon = icons[i].nextElementSibling.firstElementChild.className;
      }
   }
   
   let text_color = $("#modal_text_color").spectrum('get').toHex();
   text_color = '#' + text_color;
   
   let icon_color = $("#modal_icon_color").spectrum('get').toHex();
   icon_color = '#' + icon_color;
   
   let data = {
      language: language,
      id: id,
      name_ara: name_ara,
      name_fr: name_fr,
      icon: icon,
      text_color: text_color,
      icon_color: icon_color,
      status: status
   };
   
   $.ajax({
      url: 'api/category/update',
      type: 'POST',
      data: data,
      success: function(response) {
         if(response.status) {
            $('#modal-edit-category').modal('hide');
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function LoadCategories() {
   
   let data = {
      language: language,
      status: 'all'
   }
   
   $.ajax({
      url: 'api/notice/get/all',
      type: 'POST',
      data: data,
      dataType: 'json',
      success: function(response) {
         if(response.status){
            let language_datatable = '';
            
            if(language == 'ar'){
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json"
            }else{
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/French.json"
            }
            
            table = $('#table-category').DataTable({
               "processing": true,
               "serverSide": true,
               "ajax": {
                  "url": "api/category/get/all/paginate",
                  "type": "POST",
                  "data": {
                     language: language,
                     status: 'all'
                  }
               },
               "language": {
                  "url": language_datatable
               },
               "columns": [
                  { "data": "order" },
                  { "data": "name_ara" },
                  { "data": "name_fr" },
                  { "data": "icon" },
                  { "data": "status" },
                  { "data": "action" },
               ],
               "rowReorder": {
                  dataSrc: "order",
                  selector: 'td:not(:last-child)'
               },
               "columnDefs": [
                  { "orderable": false, "targets": [0] },
                  { "orderable": false, "targets": [1] },
                  { "orderable": false, "targets": [2] },
                  { "orderable": false, "targets": [3] },
                  { "orderable": false, "targets": [4] },
                  { "orderable": false, "targets": [5] },
               ],
               "order": [[ 0, "asc" ]],
               "responsive": true,
               "scrollCollapse": true,
               "paging": true,
               //"lengthChange": true,
               "searching": true,
               "width": "100%",
               rowReorder: true,
            });
            
            rowReorder = false;
            
            table.on( 'search.dt', function () {
               if(table.search() != ''){
                  table.rowReorder.disable();
               }else{
                  if(rowReorder == false){
                     table.rowReorder.enable();
                  }
               }
            } );
            
            table.on('row-reordered', function (e, diff, edit) {  
               table.rowReorder.disable();
               
               if(!diff.length){return;}
               if(rowReorder){return;}
               
               rowReorder = true;
               
               let page = table.page.info().page;
               let length = table.page.info().length;
               let multiple = page * length;
               
               let data = {};
               
               for(var i=0; i<diff.length; i++){
                  let id = diff[i].node.children[5].children[0].id;
                  id = id.replace('n_', '');
                  let order = diff[i].newPosition + 1;
                  order = multiple + order;
                  
                  let object = {
                     id: id,
                     order: order
                  }
                  
                  data[i] = object;
                  
               }
               
               data['language'] = language;
               
               $.ajax({
                  url: 'api/category/update/order',
                  type: 'POST',
                  data: data,
                  dataType: 'json',
                  success: function(response) {
                     if(response.status){
                        toast(lang_order_updated, 'success');
                     }else{
                        toast(response.message, 'error');
                     }
                  },
                  error: function(error) {
                     console.log(error);
                  },
                  complete: function() {
                     setTimeout(function(){
                        rowReorder = false;
                        table.rowReorder.enable();
                     }, 1000);
                  }
               }); 
   
            });
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}



$(document).ready(function() {
   
   LoadCategories();
   
   $('#btn-save-category').click(function() {
      RegisterCategory();
   });
   
   let option_color = {
      color: "#ff331a",
      showInput: true,
      showInitial: true,
      preferredFormat: "hex",
      chooseText: lang_chooseText,
      cancelText: lang_cancelText,
   }
   
   $("#text_color").spectrum(option_color);
   
   $("#icon_color").spectrum(option_color);
   
});