function LogoutUser(){

   let title = '';
   let text = '';
   let confirmButtonText = '';
   let cancelButtonText = '';

   if(language == 'ar')
   {
      title = 'تأكيد';
      text = 'هل تريد تسجيل الخروج؟';
      confirmButtonText = 'نعم';
      cancelButtonText = 'لا';
      error = 'خطأ';
   }else{
      //Francais
      title = 'Confirmation';
      text = 'Voulez-vous vous déconnecter?';
      confirmButtonText = 'Oui';
      cancelButtonText = 'Non';
      error = 'Erreur';
   }

   let data = {
      language: language
   };

   Swal.fire({
      title: title,
      text: text,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: confirmButtonText,
      cancelButtonText: cancelButtonText
   }).then((result) => {
      if (result.value) {
         $.ajax({
            url: 'api/user/logout',
            type: 'POST',
            data: data,
            headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(data){
               if(data.status)
               {
                  localStorage.removeItem('user');
                  window.location.href = 'signin';
               }
               else
               {
                  Swal.fire({
                     title: error,
                     text: data.message,
                     type: 'error',
                     onClose: () => {
                        window.location.href = 'signin';
                     }
                  });
               }
            },
            error: function(data){
               Swal.fire({
                  title: error,
                  text: lang_error_logout,
                  type: 'error'
               });
            }
         });
      }
   })
}

function updatePassword(){
   let old_password = document.getElementById('old_password').value;
   let new_password = document.getElementById('new_password').value;
   let confirm_password = document.getElementById('confirm_password').value;
   
   let data = {
      old_password: old_password,
      new_password: new_password,
      confirm_password: confirm_password,
      language: language
   };
   
   let url = 'api/user/update/password';
   
   $.ajax({
      url: url,
      type: 'POST',
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      data: data,
      success: function(data){
         if(data.status)
         {
            Swal.fire({
               title: lang_success,
               text: data.message,
               type: 'success',
               confirmButtonColor: '#fb3219',
            });
            
            //Limpiar campos
            document.getElementById('old_password').value = '';
            document.getElementById('new_password').value = '';
            document.getElementById('confirm_password').value = '';
         }
         else
         {
            Swal.fire({
               title: lang_error,
               text: data.message,
               type: 'error',
               confirmButtonColor: '#fb3219',
            });
         }
      },
      error: function(data){
         Swal.fire({
            title: lang_error,
            text: lang_error_password,
            type: 'error'
         });
      }
   });
   
}

function updateUserData(){

   let name = document.getElementById('user_name_profile_input').value;
   let email = document.getElementById('user_email_profile_input').value;
   
   let data = {
      name: name,
      email: email,
      language: language

   };
   
   let url = 'api/user/update';
   
   $.ajax({
      url: url,
      type: 'POST',
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      data: data,
      success: function(response){
         if(response.status)
         {
            document.getElementById("user_name_profile").innerHTML = response.user.name;
            document.getElementById("user_name").innerHTML = response.user.name;
            localStorage.setItem('user', JSON.stringify(response.user));

            Swal.fire({
               title: lang_success,
               text: response.message,
               type: 'success',
               confirmButtonColor: '#fb3219',
            });

         }
         else
         {
            Swal.fire({
               title: lang_error,
               text: response.message,
               type: 'error',
               confirmButtonColor: '#fb3219',
            });
         }
      },
      error: function(data){
         Swal.fire({
            title: lang_error,
            text: lang_error_update,
            type: 'error',
            confirmButtonColor: '#fb3219',
         });
      }
      
   });
}

function changeLanguage(lang){
   let language = '';

   if(lang == 'ar')
   {
      language = 'fr';
      lang_success = 'Succès';
   }
   else
   {
      language = 'ar';
      lang_success = 'نجاح';
   }

   let data = {
      language: language
   };
   

   let url = 'api/user/update/language';

   $.ajax({
      url: url,
      type: 'POST',
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
      data: data,
      success: function(response){
         if(response.status)
         {
            localStorage.setItem('user', JSON.stringify(response.user));
            localStorage.setItem('language', response.user.language);
            
            Swal.fire({
               title: lang_success,
               text: response.message,
               type: 'success',
               confirmButtonColor: '#fb3219',
            });

            setTimeout(function(){
               window.location.reload();
            }, 1000);
               
         }
         else
         {
            Swal.fire({
               title: lang_error,
               text: response.message,
               type: 'error',
               confirmButtonColor: '#fb3219',
            });
         }
      },
      error: function(data){
         Swal.fire({
            title: lang_error,
            text: lang_error_update,
            type: 'error',
            confirmButtonColor: '#fb3219',
         });
      }
   });
}

function toast(message, icon){
   const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: true,
      customClass: {
         container: 'z-position-swal'
       },
      didOpen: (toast) => {
         toast.addEventListener('mouseenter', Swal.stopTimer)
         toast.addEventListener('mouseleave', Swal.resumeTimer)
      }
   })
   Toast.fire({
      icon: icon,
      title: message
   });
}

window.onload = function(){
   let user = JSON.parse(localStorage.getItem('user'));
   document.getElementById('user_name').innerHTML = user.name;
};