var table = null;
var rowReorder = null;

function RegisterUser()
{
   let name = $('#name').val();
   let email = $('#email').val();
   let password = $('#password').val();
   let language = $('#language').val();   
   
   let data = {
      language: language,
      name: name,
      email: email,
      password: password
   };
   
   $.ajax({
      url: 'api/user/register',
      type: 'POST',
      data: data,
      success: function(response) {
         if(response.status) {
            $('#name').val('');
            $('#email').val('');
            $('#password').val('');
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
   
}

function LoadUsers() {
   
   let data = {
      language: language
   }
   
   $.ajax({
      url: 'api/user/get/all',
      type: 'POST',
      data: data,
      dataType: 'json',
      success: function(response) {
         if(response.status){
            let language_datatable = '';
            
            if(language == 'ar'){
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json"
            }else{
               language_datatable = "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/French.json"
            }
            
            table = $('#table-users').DataTable({
               "processing": true,
               "serverSide": true,
               "ajax": {
                  "url": "api/user/get/all/paginate",
                  "type": "POST",
                  "data": {
                     language: language,
                  }
               },
               "language": {
                  "url": language_datatable
               },
               "columns": [
                  { "data": "name" },
                  { "data": "email" },
                  { "data": "action" },
               ],
               "columnDefs": [
                  { "orderable": false, "targets": [0] },
                  { "orderable": false, "targets": [1] },
                  { "orderable": false, "targets": [2] },
               ],
               "order": [[ 0, "asc" ]],
               "responsive": true,
               "scrollCollapse": true,
               "paging": true,
               "searching": true,
               "width": "100%",
               rowReorder: true,
            });
            
            rowReorder = false;
            
            table.on( 'search.dt', function () {
               if(table.search() != ''){
                  table.rowReorder.disable();
               }else{
                  if(rowReorder == false){
                     table.rowReorder.enable();
                  }
               }
            } );
         
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function EditUserModal(id)
{
   let data = {
      language: language,
      id: id
   };
   
   $.ajax({
      data: data,
      url: 'api/user/get/id',
      type: 'POST',
      success: function(response) {
         if(response.status)
         {
            
            let user = response.data;
            $('#modal_name').val(user.name);
            $('#modal_email').val(user.email);
            $('#modal_id').val(user.id);

            $('#modal-edit-user').modal('show');
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function SaveEditUser(){
   let name = $('#modal_name').val();
   let email = $('#modal_email').val();
   let id = $('#modal_id').val();
   
   let data = {
      language: language,
      name: name,
      email: email,
      id: id
   };
   
   $.ajax({
      url: 'api/user/update/id',
      type: 'POST',
      data: data,
      success: function(response) {
         if(response.status) {
            $('#modal_name').val('');
            $('#modal_email').val('');
            $('#modal_id').val('');
            $('#modal-edit-user').modal('hide');
            table.ajax.reload(null, false);
            toast(response.message, 'success');
         }else{
            toast(response.message, 'error');
         }
      },
      error: function(error) {
         console.log(error);
      }
   });
}

function DeleteUser(id){
   
   let data = {
      language: language,
      id: id
   };
   
   let title = '';
   let text = '';
   let confirmButtonText = '';
   let cancelButtonText = '';
   
   if(language == 'ar')
   {
      title = 'هل أنت متأكد؟';
      text = "!لن تتمكن من استعادة هذا العنصر";
      confirmButtonText = 'نعم، احذفه!';
      cancelButtonText = 'إلغاء';
   }else{
      //French
      title = 'Êtes-vous sûr?';
      text = "Vous ne pourrez pas récupérer cet élément!";
      confirmButtonText = 'Oui, supprimez-le!';
      cancelButtonText = 'Annuler';
   }
   
   Swal.fire({
      title: title,
      text: text,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: confirmButtonText,
      cancelButtonText: cancelButtonText
   }).then((result) => {
      if (result.value) {
         $.ajax({
            url: 'api/user/delete/id',
            type: 'POST',
            data: data,
            success: function(response){
               if(response.status) {
                  table.ajax.reload(null, false);
                  toast(response.message, 'success');
               }else{
                  toast(response.message, 'error');
               }
            },
            error: function(error) {
               console.log(error);
            }
         });
      }
   })
}

$(document).ready(function() {
   
   LoadUsers();
   
   $('#btn-save-administrator').click(function() {
      RegisterUser();
   });
      
});