<?php
// Clear Laravel caches that might be causing routing issues

echo "<h2>Laravel Cache Clearing</h2>";

// Change to Laravel directory
chdir('/home/alakhbarpressapp/public_html/last/application');

echo "<h3>1. Clearing route cache...</h3>";
$output1 = shell_exec('php artisan route:clear 2>&1');
echo "<pre>$output1</pre>";

echo "<h3>2. Clearing config cache...</h3>";
$output2 = shell_exec('php artisan config:clear 2>&1');
echo "<pre>$output2</pre>";

echo "<h3>3. Clearing view cache...</h3>";
$output3 = shell_exec('php artisan view:clear 2>&1');
echo "<pre>$output3</pre>";

echo "<h3>4. Clearing application cache...</h3>";
$output4 = shell_exec('php artisan cache:clear 2>&1');
echo "<pre>$output4</pre>";

echo "<h3>5. Testing API endpoint...</h3>";

// Test the API endpoint
$url = 'https://alakhbarpressapp.com/last/api/notice/get/all';
$data = array(
    'language' => 'ar',
    'status' => 'all'
);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/x-www-form-urlencoded'
));

$result = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p><strong>HTTP Status Code:</strong> $http_code</p>";
echo "<p><strong>API Response:</strong></p>";
echo "<pre>" . htmlspecialchars($result) . "</pre>";

if ($http_code == 200) {
    echo "<p style='color: green;'><strong>✅ SUCCESS! API is working!</strong></p>";
} else {
    echo "<p style='color: red;'><strong>❌ API still has issues</strong></p>";
}
?>
