<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CategoryController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('signin', function(){
    return view('signin');
})->name('signin');

Route::post('/user/login', [AuthController::class, 'LoginUser']);

Route::get('/', function () {
    if(Auth::check()){
        return redirect()->route('home');
    }
    return redirect()->route('signin');
});

Route::get('/home', function () {
    if(Auth::check()){
        return view('home');
    }
    return redirect()->route('signin');
})->name('home');

Route::get('/categories', function(){
        if(Auth::check()){
        return view('categories');
    }
    return redirect()->route('signin');
})->name('categories');

Route::get('news', function(){
        if(Auth::check()){
        return view('news');
    }
    return redirect()->route('signin');
})->name('news');


Route::get('profile', function(){
        if(Auth::check()){
        return view('profile');
    }
    return redirect()->route('signin');
})->name('profile');

Route::get('administrators', function(){
        if(Auth::check()){
        return view('administrators');
    }
    return redirect()->route('signin');
})->name('administrators');