@extends('layouts.app')

@section('content')

<!-- container -->
<div class="container-fluid">
   
   <!-- breadcrumb -->
   <div class="breadcrumb-header justify-content-between">
      <div class="my-auto">
         <div class="d-flex">
            <h4 class="content-title mb-0 my-auto">{!!trans('profile.profile')!!}</h4>
         </div>
      </div>
   </div>
   <!-- breadcrumb -->
   <!-- row -->
   <div class="row row-sm">
      <!-- Col -->
      <div class="col-lg-4">
         <div class="card mg-b-20">
            <div class="card-body">
               <div class="ps-0">
                  <div class="main-profile-overview">
                     <div class="main-img-user profile-user">
                        <img alt="" src="{{ asset('public/assets/img/faces/user.png')}}">
                     </div>
                     <div class="d-flex justify-content-between mg-b-10">
                        <div>
                           <h5 class="main-profile-name" id="user_name_profile">{!!trans('profile.user_name')!!}</h5>
                        </div>
                     </div>
                  </div><!-- main-profile-overview -->
               </div>
            </div>
         </div>
      </div>
      
      <!-- Col -->
      <div class="col-lg-8">
         <div class="card">
            <div class="card-body">
               <div class="panel panel-primary tabs-style-3">
                  <div class="tab-menu-heading">
                     <div class="tabs-menu ">
                        <!-- Tabs -->
                        <ul class="nav panel-tabs">
                           <li class="">
                              <a href="#profile" class="active" data-bs-toggle="tab"><i class="fa fa-user"></i> {!!trans('profile.profile')!!}</a>
                           </li>
                           <li>
                              <a href="#password" data-bs-toggle="tab"><i class="fa fa-lock"></i> {!!trans('profile.password')!!}</a>
                           </li>
                        </ul>
                     </div>
                  </div>
                  <div class="panel-body tabs-menu-body">
                     <div class="tab-content">
                        <div class="tab-pane active" id="profile">
                           <div class="mb-4 main-content-label">{!!trans('profile.user_information')!!}</div>
                           <div class="form-group ">
                              <div class="row">
                                 <div class="col-md-3">
                                    <label class="form-label">{!!trans('profile.user_name')!!}</label>
                                 </div>
                                 <div class="col-md-9">
                                    <input type="text" class="form-control"  placeholder="User Name" value="" id="user_name_profile_input">
                                 </div>
                              </div>
                           </div>
                           <div class="form-group ">
                              <div class="row">
                                 <div class="col-md-3">
                                    <label class="form-label">{!!trans('profile.email')!!}</label>
                                 </div>
                                 <div class="col-md-9">
                                    <input type="text" class="form-control"  placeholder="Email" value="" id="user_email_profile_input">
                                 </div>
                              </div>
                           </div>
                           <div class="card-footer">
                              <button type="submit" class="btn btn-primary-alakbar waves-effect waves-light" onclick="updateUserData()">{!!trans('profile.update_profile')!!}</button>
                           </div>
                        </div>
                        <div class="tab-pane" id="password">
                           <div class="form-group ">
                              <div class="row">
                                 <div class="col-md-3">
                                    <label class="form-label">{!!trans('profile.actual_password')!!}</label>
                                 </div>
                                 <div class="col-md-9">
                                    <input type="password" class="form-control"  placeholder="**************" id="old_password">
                                 </div>
                              </div>
                           </div>
                           <div class="form-group ">
                              <div class="row">
                                 <div class="col-md-3">
                                    <label class="form-label">{!!trans('profile.new_password')!!}</label>
                                 </div>
                                 <div class="col-md-9">
                                    <input type="password" class="form-control"  placeholder="**************" id="new_password">
                                 </div>
                              </div>
                           </div>
                           <div class="form-group ">
                              <div class="row">
                                 <div class="col-md-3">
                                    <label class="form-label">{!!trans('profile.confirm_password')!!}</label>
                                 </div>
                                 <div class="col-md-9">
                                    <input type="password" class="form-control"  placeholder="**************" id="confirm_password">
                                 </div>
                              </div>
                           </div>
                           <div class="card-footer">
                              <button type="submit" class="btn btn-primary-alakbar waves-effect waves-light" onclick="updatePassword()">{!!trans('profile.update_password')!!}</button>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>               
            </div>
         </div>
      </div>
      <!-- /Col -->
   </div>
   <!-- row closed -->
</div>
<!-- Container closed -->
@endsection

@section('scripts')
<script src="{{ asset('public/script/app.js')}}"></script>
<script>
   let user_data = localStorage.getItem('user');
   user_data = JSON.parse(user_data);
   document.getElementById("user_name_profile").innerHTML = user_data.name;
   document.getElementById("user_email_profile_input").value = user_data.email;
   document.getElementById("user_name_profile_input").value = user_data.name;
</script>
@stop
