@extends('layouts.app')

@section('content')

<!-- container -->
<div class="container-fluid">
   <!-- breadcrumb -->
   <div class="breadcrumb-header justify-content-between">
      <div class="my-auto">
         <div class="d-flex">
            <h4 class="content-title mb-0 my-auto">{!!trans('categories.categories')!!}</h4>
         </div>
      </div>
   </div>
   <!-- breadcrumb -->
   
   <!-- row opened-->
   <div class="row">
      <div class="col-12 col-sm-12 col-lg-12 col-xl-12">
         <div class="card">
            <div class="card-body">
               <!-- Tabs -->
               <div class="panel panel-primary tabs-style-3 border-0">
                  <div class="tab-menu-heading">
                     <div class="tabs-menu ">
                        <!-- Tabs -->
                        <ul class="nav panel-tabs">
                           <li class=""><a href="#register" class="active" data-bs-toggle="tab">
                              <i class="fa-solid fa-file-pen"></i> {!!trans('categories.register')!!}</a>
                           </li>
                           <li><a href="#table" data-bs-toggle="tab">
                              <i class="fa-solid fa-magnifying-glass"></i> {!!trans('categories.consult')!!}</a>
                           </li>
                        </ul>
                     </div>
                  </div>
                  <div class="panel-body tabs-menu-body">
                     <div class="tab-content">
                        <!-- Tab Register -->
                        <div class="tab-pane active" id="register">
                           <div class="form-group">
                              <label for="name_ara">{!!trans('categories.arabic_name')!!}</label>
                              <input type="text" class="form-control" id="name_ara" placeholder="{!!trans('categories.arabic_name')!!}">
                           </div>
                           <div class="form-group">
                              <label for="name_fr">{!!trans('categories.french_name')!!}</label>
                              <input type="email" class="form-control" id="name_fr" placeholder="{!!trans('categories.french_name')!!}">
                           </div>
                           <div class="form-group">
                              <p class="mg-b-10">{!!trans('categories.text_color')!!}</p>
                              <input type="text" id="text_color">
                           </div>
                           <div class="form-group">
                              <p class="mg-b-10">{!!trans('categories.select_icon')!!}</p>
                              <div class="form-group">
                                 <!-- Lista de iconos 
                                    - Home
                                    - Futbol
                                    - baseball-bat-ball
                                    - Building
                                    - Car
                                    - Newspaper
                                    - Pencil
                                    - Microphone
                                    - Music
                                    - Microscope
                                    - Children
                                    - Pen
                                    - kitchen-set
                                    - Pencil-ruler
                                 -->
                                 <div class="row">
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline1" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline1">
                                             <i class="fa-solid fa-check-circle"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline2" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline2">
                                             <i class="fa-solid fa-home"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline3" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline3">
                                             <i class="fa-solid fa-futbol"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline4" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline4">
                                             <i class="fa-solid fa-baseball-bat-ball"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline5" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline5">
                                             <i class="fa-solid fa-building"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline6" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline6">
                                             <i class="fa-solid fa-car"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline7" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline7">
                                             <i class="fa-solid fa-newspaper"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline8" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline8">
                                             <i class="fa-solid fa-pencil"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline9" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline9">
                                             <i class="fa-solid fa-microphone"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline10" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline10">
                                             <i class="fa-solid fa-music"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline11" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline11">
                                             <i class="fa-solid fa-microscope"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline12" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline12">
                                             <i class="fa-solid fa-children"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline13" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline13">
                                             <i class="fa-solid fa-pen"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline14" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline14">
                                             <i class="fa-solid fa-kitchen-set"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline15" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline15">
                                             <i class="fa-solid fa-pencil-ruler"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <!-- Other Icons 
                                       - book-quran
                                       - mosque
                                       - graduation-cap
                                       - building-columns
                                       - sack-dollar
                                       - stethoscope
                                       - hospital
                                       - scale-balanced
                                       - camera
                                       - radio
                                       - microphone
                                       - tv
                                       - map
                                       - map-location
                                       - road
                                    -->
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline16" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline16">
                                             <i class="fa-solid fa-book-quran"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline17" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline17">
                                             <i class="fa-solid fa-mosque"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline18" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline18">
                                             <i class="fa-solid fa-graduation-cap"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline19" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline19">
                                             <i class="fa-solid fa-building-columns"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline20" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline20">
                                             <i class="fa-solid fa-sack-dollar"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline21" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline21">
                                             <i class="fa-solid fa-stethoscope"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline22" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline22">
                                             <i class="fa-solid fa-hospital"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline23" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline23">
                                             <i class="fa-solid fa-scale-balanced"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline24" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline24">
                                             <i class="fa-solid fa-camera"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline25" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline25">
                                             <i class="fa-solid fa-radio"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline26" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline26">
                                             <i class="fa-solid fa-microphone"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline27" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline27">
                                             <i class="fa-solid fa-tv"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline28" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline28">
                                             <i class="fa-solid fa-map"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline29" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline29">
                                             <i class="fa-solid fa-map-location"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline30" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline30">
                                             <i class="fa-solid fa-road"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <!-- Others icons 
                                       - earth-africa
                                       - recycle
                                       - trash
                                       - tree
                                       - trophy
                                       - head-side-mask
                                       - truck
                                       - industry
                                    -->
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline31" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline31">
                                             <i class="fa-solid fa-earth-africa"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline32" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline32">
                                             <i class="fa-solid fa-recycle"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline33" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline33">
                                             <i class="fa-solid fa-trash"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline34" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline34">
                                             <i class="fa-solid fa-tree"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline35" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline35">
                                             <i class="fa-solid fa-trophy"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline36" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline36">
                                             <i class="fa-solid fa-head-side-mask"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline37" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline37">
                                             <i class="fa-solid fa-truck"></i>
                                          </label>
                                       </div>
                                    </div>
                                    <div class="col-2 col-xs-12">
                                       <div class="custom-control custom-radio custom-control-inline">
                                          <input type="radio" id="customRadioInline38" name="customRadioInline1" class="custom-control-input">
                                          <label class="custom-control-label" for="customRadioInline38">
                                             <i class="fa-solid fa-industry"></i>
                                          </label>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="form-group">
                              <p class="mg-b-10">{!!trans('categories.icon_color')!!}</p>
                              <input type="text" id="icon_color">
                           </div>
                           <div class="form-group">
                              <p class="mg-b-10">{!!trans('categories.select_status')!!}</p>
                              <select class="form-control select2" data-placeholder="Select Status" id="status">
                                 <option value="true">
                                    {!!trans('categories.active')!!}
                                 </option>
                                 <option value="false">
                                    {!!trans('categories.inactive')!!}
                                 </option>
                              </select>
                           </div>
                           <div class="form-group">
                              <button type="button" class="btn btn-block btn-primary-alakbar" id="btn-save-category">
                                 <i class="fa fa-save"></i> {!!trans('categories.register')!!}
                              </button>
                           </div>
                        </div>
                        <!-- end Tab register -->
                        <!-- Start Tab Table-->
                        <div class="tab-pane" id="table">
                           <div class="table-responsive">
                              <table class="table mg-b-0 text-md-nowrap" id="table-category">
                                 <thead>
                                    <tr>
                                       <th>{!!trans('categories.order')!!}</th>
                                       <th>{!!trans('categories.arabic_name')!!}</th>
                                       <th>{!!trans('categories.french_name')!!}</th>
                                       <th>{!!trans('categories.icon')!!}</th>
                                       <th>{!!trans('categories.status')!!}</th>
                                       <th>{!!trans('categories.action')!!}</th>
                                    </tr>
                                 </thead>
                                 <tbody id="table-body-category">
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <!-- End Tab Table-->
                     </div>
                  </div>
               </div>
               <!-- Tabs -->
            </div>
         </div>
      </div>
   </div>
   <!--row closed-->
   
</div>
<!-- /Container -->
</div>
<!-- /main-content -->

<!--Modal editar categoria-->
<div class="modal fade" id="modal-edit-category" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">
               <i class="fa fa-edit"></i> {!!trans('categories.category_edit')!!}
            </h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div class="form-group d-none">
                     <input type="text" class="form-control" id="modal_id">
                  </div>
                  <div class="form-group">
                     <label for="name_ar">{!!trans('categories.arabic_name')!!}</label>
                     <input type="text" class="form-control" id="modal_name_ara" placeholder="{!!trans('categories.arabic_name')!!}">
                  </div>
                  <div class="form-group">
                     <label for="name_fr">{!!trans('categories.french_name')!!}</label>
                     <input type="text" class="form-control" id="modal_name_fr" placeholder="{!!trans('categories.french_name')!!}">
                  </div>
                  <div class="form-group" id="container_modal_text_color">
                     <p class="mg-b-10">{!!trans('categories.text_color')!!}</p>
                     <input type="text" id="modal_text_color">
                  </div>
                  <div class="form-group">
                     <p class="mg-b-10">{!!trans('categories.select_icon')!!}</p>
                     <div class="form-group">
                        <!-- Lista de iconos 
                           - Home
                           - Futbol
                           - baseball-bat-ball
                           - Building
                           - Car
                           - Newspaper
                           - Pencil
                           - Microphone
                           - Music
                           - Microscope
                           - Children
                           - Pen
                           - kitchen-set
                           - Pencil-ruler
                        -->
                        <div class="row">
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline1" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline1">
                                    <i class="fa-solid fa-check-circle"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline2" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline2">
                                    <i class="fa-solid fa-home"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline3" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline3">
                                    <i class="fa-solid fa-futbol"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline4" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline4">
                                    <i class="fa-solid fa-baseball-bat-ball"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline5" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline5">
                                    <i class="fa-solid fa-building"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline6" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline6">
                                    <i class="fa-solid fa-car"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline7" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline7">
                                    <i class="fa-solid fa-newspaper"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline8" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline8">
                                    <i class="fa-solid fa-pencil"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline9" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline9">
                                    <i class="fa-solid fa-microphone"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline10" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline10">
                                    <i class="fa-solid fa-music"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline11" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline11">
                                    <i class="fa-solid fa-microscope"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline12" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline12">
                                    <i class="fa-solid fa-children"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline13" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline13">
                                    <i class="fa-solid fa-pen"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline14" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline14">
                                    <i class="fa-solid fa-kitchen-set"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline15" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline15">
                                    <i class="fa-solid fa-pencil-ruler"></i>
                                 </label>
                              </div>
                           </div>
                           <!-- Other Icons 
                              - book-quran
                              - mosque
                              - graduation-cap
                              - building-columns
                              - sack-dollar
                              - stethoscope
                              - hospital
                              - scale-balanced
                              - camera
                              - radio
                              - microphone
                              - tv
                              - map
                              - map-location
                              - road
                           -->
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline16" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline16">
                                    <i class="fa-solid fa-book-quran"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline17" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline17">
                                    <i class="fa-solid fa-mosque"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline18" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline18">
                                    <i class="fa-solid fa-graduation-cap"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline19" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline19">
                                    <i class="fa-solid fa-building-columns"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline20" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline20">
                                    <i class="fa-solid fa-sack-dollar"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline21" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline21">
                                    <i class="fa-solid fa-stethoscope"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline22" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline22">
                                    <i class="fa-solid fa-hospital"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline23" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline23">
                                    <i class="fa-solid fa-scale-balanced"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline24" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline24">
                                    <i class="fa-solid fa-camera"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline25" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline25">
                                    <i class="fa-solid fa-radio"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline26" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline26">
                                    <i class="fa-solid fa-microphone"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline27" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline27">
                                    <i class="fa-solid fa-tv"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline28" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline28">
                                    <i class="fa-solid fa-map"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline29" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline29">
                                    <i class="fa-solid fa-map-location"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline30" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline30">
                                    <i class="fa-solid fa-road"></i>
                                 </label>
                              </div>
                           </div>
                           <!-- Others icons 
                              - earth-africa
                              - recycle
                              - trash
                              - tree
                              - trophy
                              - head-side-mask
                              - truck
                              - industry
                           -->
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline31" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline31">
                                    <i class="fa-solid fa-earth-africa"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline32" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline32">
                                    <i class="fa-solid fa-recycle"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline33" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline33">
                                    <i class="fa-solid fa-trash"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline34" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline34">
                                    <i class="fa-solid fa-tree"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline35" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline35">
                                    <i class="fa-solid fa-trophy"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline36" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline36">
                                    <i class="fa-solid fa-head-side-mask"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline37" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline37">
                                    <i class="fa-solid fa-truck"></i>
                                 </label>
                              </div>
                           </div>
                           <div class="col-2 col-xs-12">
                              <div class="custom-control custom-radio custom-control-inline">
                                 <input type="radio" id="EcustomRadioInline38" name="customRadioInline2" class="custom-control-input">
                                 <label class="custom-control-label" for="EcustomRadioInline38">
                                    <i class="fa-solid fa-industry"></i>
                                 </label>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="form-group" id="container_modal_icon_color">
                     <p class="mg-b-10">{!!trans('categories.icon_color')!!}</p>
                     <input type="text" id="modal_icon_color">
                  </div>
                  <div class="form-group">
                     <label for="status">{!!trans('categories.status')!!}</label>
                     <select class="form-control select2" data-placeholder="Status" id="modal_status">
                        <option value="true">
                           <i class="fa fa-check"></i>
                           {!!trans('categories.active')!!}
                        </option>
                        <option value="false">
                           <i class="fa fa-times"></i>
                           {!!trans('categories.inactive')!!}
                        </option>
                     </select>
                  </div>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{!!trans('categories.close')!!}</button>
            <button type="button" class="btn btn-primary-alakbar" id="btn-save-category" onclick="SaveEditCategory()">{!!trans('categories.save')!!}</button>
         </div>
      </div>
   </div>
</div>

@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.js" integrity="sha512-1aNp9qKP+hKU/VJwCtYqJP9tdZWbMDN5pEEXXoXT0pTAxZq1HHZhNBR/dtTNSrHO4U1FsFGGILbqG1O9nl8Mdg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<link href="https://cdn.datatables.net/rowreorder/1.2.8/css/rowReorder.dataTables.min.css" rel="stylesheet">
<script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.css" integrity="sha512-KuSX+43gVS5MEIJD2ewtrFPOHqC1PJnL8o2f5ciggPC0JUZ8XV0QXlfArO1mSzKkVFdRjsBDfrTU96C5SuRfqQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="{{ asset('public/script/category.js') }}"></script>
@endsection