<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Notice;
use App\Models\Category;
use App\Models\Comments;
use App\Models\ConsultedTimes;
use App\Models\LikeComment;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use Carbon\Carbon;

use DB;
use Storage;

class NoticeController extends Controller
{
    public function Register(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'exclusive' => 'required|in:ar,fr,both',
            ],
            $messages = [
                'exclusive.required' => 'يجب اختيار اللغة المستخدمة في الإعلان',
                'exclusive.in' => 'يجب اختيار اللغة المستخدمة في الإعلان',
            ]);
            
        }else{
            $vld = Validator::make($data, [
                'exclusive' => 'required|in:ar,fr,both',
            ],
            $messages = [
                'exclusive.required' => 'Vous devez choisir la langue utilisée dans l\'annonce',
                'exclusive.in' => 'Vous devez choisir la langue utilisée dans l\'annonce',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $exclusive = $data['exclusive'];
        
        if($exclusive == 'both'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'title_ara' => 'required|string|max:255',
                    'title_fr' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_ara.required' => 'يجب إدخال عنوان الإعلان باللغة العربية',
                    'title_ara.string' => 'يجب إدخال عنوان الإعلان باللغة العربية',
                    'title_ara.max' => 'يجب ألا يتجاوز عنوان الإعلان باللغة العربية 255 حرفاً',
                    'title_fr.required' => 'يجب إدخال عنوان الإعلان باللغة الفرنسية',
                    'title_fr.string' => 'يجب إدخال عنوان الإعلان باللغة الفرنسية',
                    'title_fr.max' => 'يجب ألا يتجاوز عنوان الإعلان باللغة الفرنسية 255 حرفاً',
                    'description_ara.required' => 'يجب إدخال وصف الإعلان باللغة العربية',
                    'description_ara.string' => 'يجب إدخال وصف الإعلان باللغة العربية',
                    'description_ara.max' => 'يجب ألا يتجاوز وصف الإعلان باللغة العربية 255 حرفاً',
                    'description_fr.required' => 'يجب إ دخال وصف الإعلان باللغة الفرنسية',
                    'description_fr.string' => 'يجب إدخال وصف الإعلان باللغة الفرنسية',
                    'description_fr.max' => 'يجب ألا يتجاوز وصف الإعلان باللغة الفرنسية 255 حرفاً',
                    'content_ara.required' => 'يجب إدخال محتوى الإعلان باللغة العربية',
                    'content_ara.string' => 'يجب إدخال محتوى الإعلان باللغة العربية',
                    'content_ara.max' => 'يجب ألا يتجاوز محتوى الإعلان باللغة العربية 6553500 حرفاً',
                    'content_fr.required' => 'يجب إدخال محتوى الإعلان باللغة الفرنسية',
                    'content_fr.string' => 'يجب إدخال محتوى الإعلان باللغة الفرنسية',
                    'content_fr.max' => 'يجب ألا يتجاوز محتوى الإعلان باللغة الفرنسية 6553500 حرفاً',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'image.required' => 'يجب إدخال صورة الإعلان',
                    'image.mimes' => 'يجب أن يكون صورة الإعلان بصيغة jpeg,png,jpg,gif,svg',
                    'image.max' => 'يجب ألا يتجاوز صورة الإعلان 2048 بايت',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'author_ar.required' => 'يجب إدخال الكاتب',
                    'author_ar.string' => 'يجب إدخال الكاتب',
                    'author_ar.max' => 'يجب ألا يتجاوز الكاتب 255 حرفاً',
                    'author_fr.required' => 'يجب إدخال الكاتب',
                    'author_fr.string' => 'يجب إدخال الكاتب',
                    'author_fr.max' => 'يجب ألا يتجاوز الكاتب 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'title_ara' => 'required|string|max:255',
                    'title_fr' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:6553500',
                    'description_fr' => 'required|string|max:6553500',
                    'content_ara' => 'required|string|max:6553500',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_ara.required' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.string' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.max' => 'Le titre de l\'annonce doit être saisi en arabe avec 255 caractères maximum',
                    'title_fr.required' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.string' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.max' => 'Le titre de l\'annonce doit être saisi en français avec 255 caractères maximum',
                    'description_ara.required' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.string' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.max' => 'La description de l\'annonce doit être saisie en arabe avec 6553500 caractères maximum',
                    'description_fr.required' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.string' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.max' => 'La description de l\'annonce doit être saisie en français avec 6553500 caractères maximum',
                    'content_ara.required' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.string' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.max' => 'Le contenu de l\'annonce doit être saisi en arabe avec 6553500 caractères maximum',
                    'content_fr.required' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.string' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.max' => 'Le contenu de l\'annonce doit être saisi en français avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'image.required' => 'L\'image de l\'annonce doit être saisie',
                    'image.mimes' => 'L\'image de l\'annonce doit être saisie en jpeg,png,jpg,gif,svg',
                    'image.max' => 'L\'image de l\'annonce doit être saisie avec 2048 octets maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_ar.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_fr.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'la catégorie d\'annonce n\'existe pas',
                    'status.required' => 'Le statut de l\'annonce doit être saisi',
                    'status.in' => 'Le statut de l\'annonce doit être saisi',
                ]);
            }
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if($exclusive == 'ar'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'title_ara' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_ara.required' => 'يجب إدخال عنوان الإعلان باللغة العربية',
                    'title_ara.string' => 'يجب إدخال عنوان الإعلان باللغة العربية',
                    'title_ara.max' => 'يجب ألا يتجاوز عنوان الإعلان باللغة العربية 255 حرفاً',
                    'description_ara.required' => 'يجب إدخال وصف الإعلان باللغة العربية',
                    'description_ara.string' => 'يجب إدخال وصف الإعلان باللغة العربية',
                    'description_ara.max' => 'يجب ألا يتجاوز وصف الإعلان باللغة العربية 255 حرفاً',
                    'content_ara.required' => 'يجب إدخال محتوى الإعلان باللغة العربية',
                    'content_ara.string' => 'يجب إدخال محتوى الإعلان باللغة العربية',
                    'content_ara.max' => 'يجب ألا يتجاوز محتوى الإعلان باللغة العربية 6553500 حرفاً',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'image.required' => 'يجب إدخال صورة الإعلان',
                    'image.mimes' => 'يجب أن يكون صورة الإعلان بصيغة jpeg,png,jpg,gif,svg',
                    'image.max' => 'يجب ألا يتجاوز صورة الإعلان 2048 بايت',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'author_ar.required' => 'يجب إدخال الكاتب',
                    'author_ar.string' => 'يجب إدخال الكاتب',
                    'author_ar.max' => 'يجب ألا يتجاوز الكاتب 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'title_ara' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:6553500',
                    'content_ara' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_ara.required' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.string' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.max' => 'Le titre de l\'annonce doit être saisi en arabe avec 255 caractères maximum',
                    'description_ara.required' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.string' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.max' => 'La description de l\'annonce doit être saisie en arabe avec 6553500 caractères maximum',
                    'content_ara.required' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.string' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.max' => 'Le contenu de l\'annonce doit être saisi en arabe avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'image.required' => 'L\'image de l\'annonce doit être saisie',
                    'image.mimes' => 'L\'image de l\'annonce doit être saisie en jpeg,png,jpg,gif,svg',
                    'image.max' => 'L\'image de l\'annonce doit être saisie avec 2048 octets maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_ar.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'la catégorie d\'annonce n\'existe pas',
                    'status.required' => 'Le statut de l\'annonce doit être saisi',
                    'status.in' => 'Le statut de l\'annonce doit être saisi',
                ]);
            }
            
        }
        
        if($exclusive == 'fr'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'title_fr' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_fr.required' => 'يجب إدخال عنوان الإعلان باللغة الفرنسية',
                    'title_fr.string' => 'يجب إدخال عنوان الإعلان باللغة الفرنسية',
                    'title_fr.max' => 'يجب ألا يتجاوز عنوان الإعلان باللغة الفرنسية 255 حرفاً',
                    'description_fr.required' => 'يجب إ دخال وصف الإعلان باللغة الفرنسية',
                    'description_fr.string' => 'يجب إدخال وصف الإعلان باللغة الفرنسية',
                    'description_fr.max' => 'يجب ألا يتجاوز وصف الإعلان باللغة الفرنسية 255 حرفاً',
                    'content_fr.required' => 'يجب إدخال محتوى الإعلان باللغة الفرنسية',
                    'content_fr.string' => 'يجب إدخال محتوى الإعلان باللغة الفرنسية',
                    'content_fr.max' => 'يجب ألا يتجاوز محتوى الإعلان باللغة الفرنسية 6553500 حرفاً',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'image.required' => 'يجب إدخال صورة الإعلان',
                    'image.mimes' => 'يجب أن يكون صورة الإعلان بصيغة jpeg,png,jpg,gif,svg',
                    'image.max' => 'يجب ألا يتجاوز صورة الإعلان 2048 بايت',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'author_fr.required' => 'يجب إدخال الكاتب',
                    'author_fr.string' => 'يجب إدخال الكاتب',
                    'author_fr.max' => 'يجب ألا يتجاوز الكاتب 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'title_fr' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:6553500',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'url' => 'string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages = [
                    'title_fr.required' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.string' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.max' => 'Le titre de l\'annonce doit être saisi en français avec 255 caractères maximum',
                    'description_fr.required' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.string' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.max' => 'La description de l\'annonce doit être saisie en français avec 6553500 caractères maximum',
                    'content_fr.required' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.string' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.max' => 'Le contenu de l\'annonce doit être saisi en français avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'image.required' => 'L\'image de l\'annonce doit être saisie',
                    'image.mimes' => 'L\'image de l\'annonce doit être saisie en jpeg,png,jpg,gif,svg',
                    'image.max' => 'L\'image de l\'annonce doit être saisie avec 2048 octets maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_fr.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'la catégorie d\'annonce n\'existe pas',
                    'status.required' => 'Le statut de l\'annonce doit être saisi',
                    'status.in' => 'Le statut de l\'annonce doit être saisi',
                ]);
            }
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $file = $request->file('image');
        $name = time().'.'.$file->getClientOriginalExtension();
        $file->move('public/img/notices/', $name);
        $name = 'public/img/notices/'.$name;
        $server_address = env('APP_URL').$name;
        //$server_address = url('/').'/'.$name;
        
        $notice = new Notice();
        $notice->title_ara = $data['title_ara'];
        $notice->title_fr = $data['title_fr'];
        $notice->description_ara = $data['description_ara'];
        $notice->description_fr = $data['description_fr'];
        $notice->content_ara = $data['content_ara'];
        $notice->content_fr = $data['content_fr'];
        $notice->type = $data['type'];
        $notice->image = $server_address;
        $notice->url = $data['url'] == null ? null : $data['url'];
        $notice->author_ar = $data['author_ar'];
        $notice->author_fr = $data['author_fr'];
        $notice->url_video = $data['url_video'] == null ? null : $data['url_video'];
        $notice->category_id = $data['category_id'];
        $notice->status = $data['status'];
        $notice->exclusive_languaje = $data['exclusive'];
        $notice->save();
        
        $notices = Notice::select('id', 'order')->get();
        
        foreach ($notices as $notice_order) {
            $notice_order->order = $notice_order->order + 1;
            $notice_order->save();
        }
        
        if($language == 'ar'){
            $message = 'تم التسجيل بنجاح';
        }else{
            //Frances
            $message = 'Enregistré avec succès'; 
        }
        
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function Update(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'exclusive' => 'required|in:ar,fr,both',
            ],
            $messages = [
                'exclusive.required' => 'يجب اختيار اللغة المستخدمة في الإعلان',
                'exclusive.in' => 'يجب اختيار اللغة المستخدمة في الإعلان',
            ]);
            
        }else{
            $vld = Validator::make($data, [
                'exclusive' => 'required|in:ar,fr,both',
            ],
            $messages = [
                'exclusive.required' => 'Vous devez choisir la langue utilisée dans l\'annonce',
                'exclusive.in' => 'Vous devez choisir la langue utilisée dans l\'annonce',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $exclusive = $data['exclusive'];
        
        if($exclusive == 'both'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_ara' => 'required|string|max:255',
                    'title_fr' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                //árabe
                $messages = [
                    'id.required' => 'يجب إدخال رقم الإعلان',
                    'id.integer' => 'يجب إدخال رقم الإعلان',
                    'id.exists' => 'رقم الإعلان غير موجود',
                    'title_ara.required' => 'يجب إدخال عنوان الإعلان',
                    'title_ara.string' => 'يجب إدخال عنوان الإعلان',
                    'title_ara.max' => 'يجب إدخال عنوان الإعلان بحد أقصى 255 حرف',
                    'title_fr.required' => 'يجب إدخال عنوان الإعلان',
                    'title_fr.string' => 'يجب إدخال عنوان الإعلان',
                    'title_fr.max' => 'يجب إدخال عنوان الإعلان بحد أقصى 255 حرف',
                    'description_ara.required' => 'يجب إدخال وصف الإعلان',
                    'description_ara.string' => 'يجب إدخال وصف الإعلان',
                    'description_ara.max' => 'يجب إدخال وصف الإعلان بحد أقصى 6553500 حرف',
                    'description_fr.required' => 'يجب إدخال وصف الإعلان',
                    'description_fr.string' => 'يجب إدخال وصف الإعلان',
                    'description_fr.max' => 'يجب إدخال وصف الإعلان بحد أقصى 6553500 حرف',
                    'content_ara.required' => 'يجب إدخال محتوى الإعلان',
                    'content_ara.string' => 'يجب إدخال محتوى الإعلان',
                    'content_ara.max' => 'يجب إدخال محتوى الإعلان بحد أقصى 6553500 حرف',
                    'content_fr.required' => 'يجب إدخال محتوى الإعلان',
                    'content_fr.string' => 'يجب إدخال محتوى الإعلان',
                    'content_fr.max' => 'يجب إدخال محتوى الإعلان بحد أقصى 6553500 حرف',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'author_ar.required' => 'يجب إدخال مؤلف الإعلان',
                    'author_ar.string' => 'يجب إدخال مؤلف الإعلان',
                    'author_ar.max' => 'يجب ألا يتجاوز مؤلف الإعلان 255 حرفاً',
                    'author_fr.required' => 'يجب إدخال مؤلف الإعلان',
                    'author_fr.string' => 'يجب إدخال مؤلف الإعلان',
                    'author_fr.max' => 'يجب ألا يتجاوز مؤلف الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_ara' => 'required|string|max:255',
                    'title_fr' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages=[
                    'id.required' => 'Vous devez saisir le numéro de l\'annonce',
                    'id.integer' => 'le numéro de l\'annonce doit être renseigné',
                    'id.exists' => 'annonce introuvable',
                    'title_ara.required' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.string' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.max' => 'Le titre de l\'annonce doit être saisi en arabe avec 255 caractères maximum',
                    'title_fr.required' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.string' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.max' => 'Le titre de l\'annonce doit être saisi en français avec 255 caractères maximum',
                    'description_ara.required' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.string' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.max' => 'La description de l\'annonce doit être saisie en arabe avec 6553500 caractères maximum',
                    'description_fr.required' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.string' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.max' => 'La description de l\'annonce doit être saisie en français avec 6553500 caractères maximum',
                    'content_ara.required' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.string' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.max' => 'Le contenu de l\'annonce doit être saisi en arabe avec 6553500 caractères maximum',
                    'content_fr.required' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.string' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.max' => 'Le contenu de l\'annonce doit être saisi en français avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_ar.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_fr.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'La catégorie de l\'annonce doit être saisie',
                    'status.required' => 'La catégorie de l\'annonce doit être saisie',
                    'status.in' => 'La catégorie de l\'annonce doit être saisie',
                ]);	
            }
        }
        
        if($exclusive == 'ar'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_ara' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                //árabe
                $messages = [
                    'id.required' => 'يجب إدخال رقم الإعلان',
                    'id.integer' => 'يجب إدخال رقم الإعلان',
                    'id.exists' => 'رقم الإعلان غير موجود',
                    'title_ara.required' => 'يجب إدخال عنوان الإعلان',
                    'title_ara.string' => 'يجب إدخال عنوان الإعلان',
                    'title_ara.max' => 'يجب إدخال عنوان الإعلان بحد أقصى 255 حرف',
                    'description_ara.required' => 'يجب إدخال وصف الإعلان',
                    'description_ara.string' => 'يجب إدخال وصف الإعلان',
                    'description_ara.max' => 'يجب إدخال وصف الإعلان بحد أقصى 6553500 حرف',
                    'content_ara.required' => 'يجب إدخال محتوى الإعلان',
                    'content_ara.string' => 'يجب إدخال محتوى الإعلان',
                    'content_ara.max' => 'يجب إدخال محتوى الإعلان بحد أقصى 6553500 حرف',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'author_ar.required' => 'يجب إدخال مؤلف الإعلان',
                    'author_ar.string' => 'يجب إدخال مؤلف الإعلان',
                    'author_ar.max' => 'يجب ألا يتجاوز مؤلف الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_ara' => 'required|string|max:255',
                    'description_ara' => 'required|string|max:255',
                    'content_ara' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_ar' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages=[
                    'id.required' => 'Vous devez saisir le numéro de l\'annonce',
                    'id.integer' => 'le numéro de l\'annonce doit être renseigné',
                    'id.exists' => 'annonce introuvable',
                    'title_ara.required' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.string' => 'Le titre de l\'annonce doit être saisi en arabe',
                    'title_ara.max' => 'Le titre de l\'annonce doit être saisi en arabe avec 255 caractères maximum',
                    'description_ara.required' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.string' => 'La description de l\'annonce doit être saisie en arabe',
                    'description_ara.max' => 'La description de l\'annonce doit être saisie en arabe avec 6553500 caractères maximum',
                    'content_ara.required' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.string' => 'Le contenu de l\'annonce doit être saisi en arabe',
                    'content_ara.max' => 'Le contenu de l\'annonce doit être saisi en arabe avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_ar.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_ar.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'La catégorie de l\'annonce doit être saisie',
                    'status.required' => 'La catégorie de l\'annonce doit être saisie',
                    'status.in' => 'La catégorie de l\'annonce doit être saisie',
                ]);	
            }
        }
        
        if($exclusive == 'fr'){
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_fr' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                //árabe
                $messages = [
                    'id.required' => 'يجب إدخال رقم الإعلان',
                    'id.integer' => 'يجب إدخال رقم الإعلان',
                    'id.exists' => 'رقم الإعلان غير موجود',
                    'title_fr.required' => 'يجب إدخال عنوان الإعلان',
                    'title_fr.string' => 'يجب إدخال عنوان الإعلان',
                    'title_fr.max' => 'يجب إدخال عنوان الإعلان بحد أقصى 255 حرف',
                    'description_fr.required' => 'يجب إدخال وصف الإعلان',
                    'description_fr.string' => 'يجب إدخال وصف الإعلان',
                    'description_fr.max' => 'يجب إدخال وصف الإعلان بحد أقصى 6553500 حرف',
                    'content_fr.required' => 'يجب إدخال محتوى الإعلان',
                    'content_fr.string' => 'يجب إدخال محتوى الإعلان',
                    'content_fr.max' => 'يجب إدخال محتوى الإعلان بحد أقصى 6553500 حرف',
                    'type.required' => 'يجب إدخال نوع الإعلان',
                    'type.string' => 'يجب إدخال نوع الإعلان',
                    'type.max' => 'يجب ألا يتجاوز نوع الإعلان 255 حرفاً',
                    'url.string' => 'يجب إدخال رابط الإعلان',
                    'url.max' => 'يجب ألا يتجاوز رابط الإعلان 255 حرفاً',
                    'author_fr.required' => 'يجب إدخال مؤلف الإعلان',
                    'author_fr.string' => 'يجب إدخال مؤلف الإعلان',
                    'author_fr.max' => 'يجب ألا يتجاوز مؤلف الإعلان 255 حرفاً',
                    'url_video.string' => 'يجب إدخال رابط الفيديو',
                    'url_video.max' => 'يجب ألا يتجاوز رابط الفيديو 255 حرفاً',
                    'category_id.required' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.integer' => 'يجب إدخال تصنيف الإعلان',
                    'category_id.exists' => 'تصنيف الإعلان غير موجود',
                    'status.required' => 'يجب إدخال حالة الإعلان',
                    'status.in' => 'يجب إدخال حالة الإعلان',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'id' => 'required|integer|exists:notices,id',
                    'title_fr' => 'required|string|max:255',
                    'description_fr' => 'required|string|max:255',
                    'content_fr' => 'required|string|max:6553500',
                    'type' => 'required|string|max:255',
                    'url' => 'string|max:255',
                    'author_fr' => 'required|string|max:255',
                    'url_video' => 'string|max:255',
                    'category_id' => 'required|integer|exists:categories,id',
                    'status' => 'required|in:active,inactive',
                ],
                $messages=[
                    'id.required' => 'Vous devez saisir le numéro de l\'annonce',
                    'id.integer' => 'le numéro de l\'annonce doit être renseigné',
                    'id.exists' => 'annonce introuvable',
                    'title_fr.required' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.string' => 'Le titre de l\'annonce doit être saisi en français',
                    'title_fr.max' => 'Le titre de l\'annonce doit être saisi en français avec 255 caractères maximum',
                    'description_fr.required' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.string' => 'La description de l\'annonce doit être saisie en français',
                    'description_fr.max' => 'La description de l\'annonce doit être saisie en français avec 6553500 caractères maximum',
                    'content_fr.required' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.string' => 'Le contenu de l\'annonce doit être saisi en français',
                    'content_fr.max' => 'Le contenu de l\'annonce doit être saisi en français avec 6553500 caractères maximum',
                    'type.required' => 'Le type de l\'annonce doit être saisi',
                    'type.string' => 'Le type de l\'annonce doit être saisi',
                    'type.max' => 'Le type de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url.string' => 'Le lien de l\'annonce doit être saisi',
                    'url.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'author_fr.required' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.string' => 'L\'auteur de l\'annonce doit être saisi',
                    'author_fr.max' => 'L\'auteur de l\'annonce doit être saisi avec 255 caractères maximum',
                    'url_video.string' => 'Le lien de l\'annonce doit être saisi',
                    'url_video.max' => 'Le lien de l\'annonce doit être saisi avec 255 caractères maximum',
                    'category_id.required' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.integer' => 'La catégorie de l\'annonce doit être saisie',
                    'category_id.exists' => 'La catégorie de l\'annonce doit être saisie',
                    'status.required' => 'La catégorie de l\'annonce doit être saisie',
                    'status.in' => 'La catégorie de l\'annonce doit être saisie',
                ]);	
            }
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if($request->hasFile('image'))
        {
            if($language == 'ar'){
                $vld = Validator::make($request->all(), [
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ],
                $messages = [
                    'image.required' => 'يجب إدخال الصورة',
                    'image.mimes' => 'يجب إدخال الصورة بصيغة jpeg,png,jpg,gif,svg',
                    'image.max' => 'يجب إدخال الصورة بحجم أقل من 2048 بايت',
                ]);
            }else{
                $vld = Validator::make($request->all(), [
                    'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ],
                //frances
                $messages = [
                    'image.required' => 'Vous devez saisir l\'image',
                    'image.mimes' => 'Vous devez saisir l\'image en jpeg,png,jpg,gif,svg',
                    'image.max' => 'Vous devez saisir l\'image avec 2048 octets maximum',
                ]);
            }
            
            if ($vld->fails()) {
                $response['message'] = $vld->errors()->first(); 
                return Response::json($response);
            }
            
            $file = $request->file('image');
            $name = time().'.'.$file->getClientOriginalExtension();
            $file->move('public/img/notices/', $name);
            $name = 'public/img/notices/'.$name;
            //Obtener el valor de env
            $server_address = env('APP_URL').$name;
            //$server_address = url('/').'/'.$name;
        }
        
        $notice = Notice::find($data['id']);
        $notice->title_ara = $data['title_ara'];
        $notice->title_fr = $data['title_fr'];
        $notice->description_ara = $data['description_ara'];
        $notice->description_fr = $data['description_fr'];
        $notice->content_ara = $data['content_ara'];
        $notice->content_fr = $data['content_fr'];
        $notice->type = $data['type'];
        if($request->hasFile('image'))
        {
            $notice->image = $server_address;
        }
        $notice->url = $data['url'] == null ? null : $data['url'];
        $notice->author_ar = $data['author_ar'];
        $notice->author_fr = $data['author_fr'];
        $notice->url_video = $data['url_video'] == null ? null : $data['url_video'];
        $notice->category_id = $data['category_id'];
        $notice->status = $data['status'];
        $notice->save();
        
        if($language == 'ar'){
            $message = 'تم التعديل بنجاح';
        }else{
            $message = 'Modifié avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);        
    }
    
    public function Delete(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:notices,id',
            ],
            $messages = [
                'id.required' => 'يجب إدخال الرقم التعريفي للإعلان',
                'id.integer' => 'يجب إدخال الرقم التعريفي للإعلان',
                'id.exists' => 'الإعلان غير موجود',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:notices,id',
            ],
            $messages = [
                'id.required' => 'Vous devez saisir l\'identifiant de l\'annonce',
                'id.integer' => 'Vous devez saisir l\'identifiant de l\'annonce',
                'id.exists' => 'L\'annonce n\'existe pas',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        //Eliminar todos los comentarios de la noticia
        $comments = Comments::where('post_id', $data['id'])->get();
        foreach($comments as $comment){
            //Eliminar los likes
            $likes = LikeComment::where('comments_id', $comment->id)->get();
            foreach($likes as $like){
                $like->delete();
            }
            $comment->delete();
        }
        
        //eliminar todos los consultas de la noticia
        $consults = ConsultedTimes::where('notices_id', $data['id'])->get();
        foreach($consults as $consult){
            $consult->delete();
        }
        
        $notice = Notice::find($data['id']);
        $order = $notice->order;
        $notice->delete();
        
        $notices = Notice::where('order', '>', $order)->get();
        
        foreach($notices as $notice){
            $notice->order = $notice->order - 1;
            $notice->save();
        }
        
        if($language == 'ar'){
            $message = 'تم الحذف بنجاح';
        }else{
            $message = 'Supprimé avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);        
    }
    
    public function GetAll(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted,all',
            ],
            $messages = [
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted,all',
            ],
            $messages = [
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        try {
            if($data['status'] == 'all'){
                $notices = DB::table('notices')
                ->join('categories', 'categories.id', '=', 'notices.category_id')
                ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
                ->orderBy('notices.order', 'desc')
                ->get();
            }else{
                $notices = DB::table('notices')
                ->join('categories', 'categories.id', '=', 'notices.category_id')
                ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
                ->where('notices.status', $data['status'])
                ->orderBy('notices.order', 'asc')
                ->get();
            }
        } catch (\Exception $e) {
            // Handle database errors gracefully
            if($language == 'ar'){
                $message = 'خطأ في قاعدة البيانات: ' . $e->getMessage();
            }else{
                $message = 'Database error: ' . $e->getMessage();
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($notices->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد بيانات';
            }else{
                $message = 'Aucune donnée trouvée';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        foreach($notices as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $notices;
        return Response::json($response);        
    }

    public function GetPaginate(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'category_id' => 'required|integer|exists:categories,id',
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'category_id.required' => 'يجب إدخال الفئة',
                'category_id.integer' => 'يجب إدخال الفئة',
                'category_id.exists' => 'الفئة غير موجودة',
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
                'page.required' => 'يجب إدخال صفحة الإعلانات',
                'page.integer' => 'يجب إدخال صفحة الإعلانات',
                'limit.required' => 'يجب إدخال عدد الإعلانات',
                'limit.integer' => 'يجب إدخال عدد الإعلانات',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'category_id' => 'required|integer|exists:categories,id',
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'category_id.required' => 'Vous devez saisir la catégorie',
                'category_id.integer' => 'Vous devez saisir la catégorie',
                'category_id.exists' => 'La catégorie n\'existe pas',
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
                'page.required' => 'Vous devez saisir la page des annonces',
                'page.integer' => 'Vous devez saisir la page des annonces',
                'limit.required' => 'Vous devez saisir le nombre d\'annonces',
                'limit.integer' => 'Vous devez saisir le nombre d\'annonces',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $page = $data['page'];
        $limit = $data['limit'];
        $offset = ($page - 1) * $limit;
        

        $notices_ar = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('category_id', $data['category_id'])
        ->where('notices.exclusive_languaje', 'ar')
        //->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.order', 'asc')
        ->get();
        
        $notices_fr = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('category_id', $data['category_id'])
        ->where('notices.exclusive_languaje', 'fr')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.order', 'asc')
        ->get();
        
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->date_fr = Carbon::parse($notices_ar[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_ar[$i]->date_ar = Carbon::parse($notices_ar[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->date_fr = Carbon::parse($notices_fr[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_fr[$i]->date_ar = Carbon::parse($notices_fr[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_ar[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_fr[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        
        if($language == 'ar'){
            if($notices_ar->isEmpty()) {
                $message = 'لا يوجد بيانات';
                $response['message'] = $message;
                $response['data'] = array();
                return Response::json($response);
            }
        }else{
            if($notices_fr->isEmpty()) {
                $message = 'Aucune donnée trouvée';
                $response['message'] = $message;
                return Response::json($response);
            }
        }
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }

        
        foreach($notices_ar as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }

        foreach($notices_fr as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        if($language == 'ar'){
            $response['message'] = 'تم الحصول على البيانات بنجاح';
            $response['data'] = $notices_ar;
        }else{
            $response['message'] = 'Données récupérées avec succès';
            $response['data'] = $notices_fr;
        }
        
        $response['status'] = true;
        return Response::json($response);
    }
    
    public function GetPaginateNotCategory(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
                'page.required' => 'يجب إدخال صفحة الإعلانات',
                'page.integer' => 'يجب إدخال صفحة الإعلانات',
                'limit.required' => 'يجب إدخال عدد الإعلانات',
                'limit.integer' => 'يجب إدخال عدد الإعلانات',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
                'page.required' => 'Vous devez saisir la page des annonces',
                'page.integer' => 'Vous devez saisir la page des annonces',
                'limit.required' => 'Vous devez saisir le nombre d\'annonces',
                'limit.integer' => 'Vous devez saisir le nombre d\'annonces',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $page = $data['page'];
        $limit = $data['limit'];
        $offset = ($page - 1) * $limit;
        
        $notices_ar = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'ar')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.order', 'asc')
        ->get();
        
        $notices_fr = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'fr')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.order', 'asc')
        ->get();
        
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->date_fr = Carbon::parse($notices_ar[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_ar[$i]->date_ar = Carbon::parse($notices_ar[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->date_fr = Carbon::parse($notices_fr[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_fr[$i]->date_ar = Carbon::parse($notices_fr[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        //Obtener la cantidad de comentarios de la noticia
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_ar[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_fr[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        if($notices_ar->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد بيانات';
            }else{
                $message = 'Aucune donnée trouvée';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            if($notices_ar->isEmpty()) {
                
                $message = 'لا يوجد بيانات';
                $response['message'] = $message;
                return Response::json($response);
            }
        }else{
            if($notices_fr->isEmpty()) {
                
                $message = 'Aucune donnée trouvée';
                $response['message'] = $message;
                return Response::json($response);
            }
        }
        
        foreach($notices_ar as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }

        foreach($notices_fr as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        if($language == 'ar'){
            $response['message'] = 'تم الحصول على البيانات بنجاح';
            $response['data'] = $notices_ar;
        }else{
            $response['message'] = 'Données récupérées avec succès';
            $response['data'] = $notices_fr;
        }

        $response['status'] = true;
        //$response['data_fr'] = $notices_fr;
        return Response::json($response);
    }
    
    public function GetPaginateMostConsulted(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
                'page.required' => 'يجب إدخال صفحة الإعلانات',
                'page.integer' => 'يجب إدخال صفحة الإعلانات',
                'limit.required' => 'يجب إدخال عدد الإعلانات',
                'limit.integer' => 'يجب إدخال عدد الإعلانات',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
                'page.required' => 'Vous devez saisir la page des annonces',
                'page.integer' => 'Vous devez saisir la page des annonces',
                'limit.required' => 'Vous devez saisir le nombre d\'annonces',
                'limit.integer' => 'Vous devez saisir le nombre d\'annonces',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $page = $data['page'];
        $limit = $data['limit'];
        $offset = ($page - 1) * $limit;
        
        $notices_ar = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'ar')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.consulted_times', 'desc')
        ->get();
        
        $notices_fr = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'fr')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.consulted_times', 'desc')
        ->get();
        
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->date_fr = Carbon::parse($notices_ar[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_ar[$i]->date_ar = Carbon::parse($notices_ar[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->date_fr = Carbon::parse($notices_fr[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_fr[$i]->date_ar = Carbon::parse($notices_fr[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        //Obtener la cantidad de comentarios de la noticia
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_ar[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_fr[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        if($notices_ar->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد بيانات';
            }else{
                $message = 'Aucune donnée trouvée';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            if($notices_ar->isEmpty()) {
                
                $message = 'لا يوجد بيانات';
                $response['message'] = $message;
                return Response::json($response);
            }
        }else{
            if($notices_fr->isEmpty()) {
                
                $message = 'Aucune donnée trouvée';
                $response['message'] = $message;
                return Response::json($response);
            }
        }
        
        foreach($notices_ar as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }

        foreach($notices_fr as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        if($language == 'ar'){
            $response['message'] = 'تم الحصول على البيانات بنجاح';
            $response['data'] = $notices_ar;
        }else{
            $response['message'] = 'Données récupérées avec succès';
            $response['data'] = $notices_fr;
        }

        $response['status'] = true;
        //$response['data_fr'] = $notices_fr;
        return Response::json($response);
    }
    
    public function GetPaginateMostCommented(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
                'page.required' => 'يجب إدخال صفحة الإعلانات',
                'page.integer' => 'يجب إدخال صفحة الإعلانات',
                'limit.required' => 'يجب إدخال عدد الإعلانات',
                'limit.integer' => 'يجب إدخال عدد الإعلانات',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'page' => 'required|integer',
                'limit' => 'required|integer',
            ],
            $messages = [
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
                'page.required' => 'Vous devez saisir la page des annonces',
                'page.integer' => 'Vous devez saisir la page des annonces',
                'limit.required' => 'Vous devez saisir le nombre d\'annonces',
                'limit.integer' => 'Vous devez saisir le nombre d\'annonces',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $page = $data['page'];
        $limit = $data['limit'];
        $offset = ($page - 1) * $limit;

        $notices_ar = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'ar')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.comments','desc')
        ->get();

        $notices_fr = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.exclusive_languaje', 'fr')
        ->orWhere('notices.exclusive_languaje', 'both')
        ->offset($offset)
        ->limit($limit)
        ->orderBy('notices.comments','desc')
        ->get();

        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->date_fr = Carbon::parse($notices_ar[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_ar[$i]->date_ar = Carbon::parse($notices_ar[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->date_fr = Carbon::parse($notices_fr[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices_fr[$i]->date_ar = Carbon::parse($notices_fr[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        //Obtener la cantidad de comentarios de la noticia
        for($i = 0; $i < count($notices_ar); $i++) {
            $notices_ar[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_ar[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        for($i = 0; $i < count($notices_fr); $i++) {
            $notices_fr[$i]->comments_count = DB::table('comments')
            ->where('post_id', $notices_fr[$i]->id)
            ->where('status', 'approved')
            ->where('language', $language)
            ->count();
        }
        
        if($language == 'ar'){
            if($notices_ar->isEmpty()) {
                
                $message = 'لا يوجد بيانات';
                $response['message'] = $message;
                return Response::json($response);
            }
        }else{
            if($notices_fr->isEmpty()) {
                
                $message = 'Aucune donnée trouvée';
                $response['message'] = $message;
                return Response::json($response);
            }
        }
        
        foreach($notices_ar as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }

        foreach($notices_fr as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        if($language == 'ar'){
            $response['message'] = 'تم الحصول على البيانات بنجاح';
            $response['data'] = $notices_ar;
        }else{
            $response['message'] = 'Données récupérées avec succès';
            $response['data'] = $notices_fr;
        }

        $response['status'] = true;
        //$response['data_fr'] = $notices_fr;
        return Response::json($response);
    }
    
    public function GetByCoincidence(Request $request){
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'search' => 'required|string',
            ],
            $messages = [
                'status.required' => 'يجب إدخال حالة الإعلان',
                'status.in' => 'حالة الإعلان غير صحيحة',
                'search.required' => 'يجب إدخال البحث',
                'search.string' => 'يجب إدخال البحث',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:active,inactive,deleted',
                'search' => 'required|string',
            ],
            $messages = [
                'status.required' => 'Vous devez saisir l\'état de l\'annonce',
                'status.in' => 'L\'état de l\'annonce est incorrect',
                'search.required' => 'Vous devez saisir la recherche',
                'search.string' => 'Vous devez saisir la recherche',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $notices =  DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
        ->where('notices.status', $data['status'])
        ->where('notices.title_ara', 'like', '%'.$data['search'].'%')
        ->orWhere('notices.title_fr', 'like', '%'.$data['search'].'%')
        ->orWhere('notices.description_ara', 'like', '%'.$data['search'].'%')
        ->orWhere('notices.description_fr', 'like', '%'.$data['search'].'%')
        ->orWhere('notices.content_ara', 'like', '%'.$data['search'].'%')
        ->orWhere('notices.content_fr', 'like', '%'.$data['search'].'%')
        ->orWhere('categories.name_ara', 'like', '%'.$data['search'].'%')
        ->orWhere('categories.name_fr', 'like', '%'.$data['search'].'%')
        ->orderBy('notices.order', 'asc')
        ->get();
        
        if($notices->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد بيانات';
            }else{
                $message = 'Aucune donnée trouvée';
            }
            
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        foreach($notices as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $notices;
        return Response::json($response);
    }
    
    public function GetById(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:notices,id',
            ],
            $messages = [
                'id.required' => 'يجب إدخال رقم الإعلان',
                'id.integer' => 'يجب إدخال رقم الإعلان',
                'id.exists' => 'رقم الإعلان غير صحيح',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:notices,id',
            ],
            $messages = [
                'id.required' => 'Vous devez saisir l\'id de l\'annonce',
                'id.integer' => 'Vous devez saisir l\'id de l\'annonce',
                'id.exists' => 'L\'id de l\'annonce est incorrect',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $notice = Notice::find($data['id']);
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
        $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $notice;
        return Response::json($response);        
    }
    
    public function GetLastThree(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $notices = DB::table('notices')
        ->join('categories', 'categories.id', '=', 'notices.category_id')
        ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr', 'categories.icon as category_icon')
        ->where('notices.status', 'active')
        ->orderBy('notices.order', 'asc')
        ->limit(5)
        ->get();
        
        if($notices->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد بيانات';
            }else{
                $message = 'No data';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        for($i = 0; $i < count($notices); $i++) {
            $notices[$i]->date_fr = Carbon::parse($notices[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $notices[$i]->date_ar = Carbon::parse($notices[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        foreach($notices as $notice){
            $notice->created_at_human_ar = Carbon::parse($notice->created_at)->locale('ar')->diffForHumans();
            $notice->created_at_human_fr = Carbon::parse($notice->created_at)->locale('fr')->diffForHumans();
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $notices;
        return Response::json($response);
    }
    
    public function GetStatsNotices(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $totalNotices = Notice::where('status', 'active')->get();
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $data = array(
            'total' => $totalNotices->count()
        );
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $data;
        return Response::json($response);
    }
    
    public function GetStatsCategories(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $totalCategories = Category::where('status', true)->get();
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $data = array(
            'total' => $totalCategories->count()
        );
        
        if($language == 'ar'){
            $message = 'تم الحصول على البيانات بنجاح';
        }else{
            $message = 'Données obtenues avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $data;
        return Response::json($response);
    }
    
    public function UpdateOrder(Request $request){
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        for($i = 0; $i < count($data)-1; $i++) {
            $notice = Notice::find($data[$i]['id']);
            $notice->order = $data[$i]['order'];
            $notice->save();
        }
        
        if($language == 'ar'){
            $message = 'تم التعديل بنجاح';
        }else{
            $message = 'Modification réussie';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function GetAllDatatableServerSide (Request $request) {
        sleep(1);
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $columns = array( 
            0 => 'order',
            1 => 'title_ara',
            2 => 'title_fr',
            3 => 'description_ara',
            4 => 'description_fr',
            5 => 'type',
            6 => 'category_id',
            7 => 'status'
        );
        
        $totalData = Notice::count();
        
        $totalFiltered = $totalData;
        
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        
        if(empty($request->input('search.value')))
        {            
            $notices = Notice::join('categories', 'categories.id', '=', 'notices.category_id')
            ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
            ->offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
        }
        else {
            $search = $request->input('search.value'); 
            
            $notices =  Notice::where('notices.title_ara','LIKE',"%{$search}%")
            ->orWhere('notices.title_fr','LIKE',"%{$search}%")
            ->orWhere('notices.description_ara','LIKE',"%{$search}%")
            ->orWhere('notices.description_fr','LIKE',"%{$search}%")
            ->orWhere('notices.type','LIKE',"%{$search}%")
            ->orWhere('notices.status','LIKE',"%{$search}%")
            ->join('categories', 'categories.id', '=', 'notices.category_id')
            ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
            ->offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
            
            $totalFiltered = Notice::where('notices.title_ara','LIKE',"%{$search}%")
            ->orWhere('notices.title_fr','LIKE',"%{$search}%")
            ->orWhere('notices.description_ara','LIKE',"%{$search}%")
            ->orWhere('notices.description_fr','LIKE',"%{$search}%")
            ->orWhere('notices.type','LIKE',"%{$search}%")
            ->orWhere('notices.status','LIKE',"%{$search}%")
            ->join('categories', 'categories.id', '=', 'notices.category_id')
            ->select('notices.*', 'categories.name_ara as category_name_ara', 'categories.name_fr as category_name_fr')
            ->count();
        }
        
        $draw = $request->input('draw');
        $data = array();
        
        if(!empty($notices))
        {
            foreach ($notices as $notice)
            {
                $nestedData['id'] = $notice->id;
                $nestedData['order'] = $notice->order;
                
                if($notice->title_ara != null){
                    $nestedData['title_ara'] = $notice->title_ara;
                }else{
                    if($language == 'ar'){
                        $nestedData['title_ara'] = 'لا توجد سجلات بيانات موجودة';
                    }else{
                        $nestedData['title_ara'] = 'Aucun enregistrement de données disponible';
                    }
                }
                
                if($notice->title_fr != null){
                    $nestedData['title_fr'] = $notice->title_fr;
                }else{
                    if($language == 'ar'){
                        $nestedData['title_fr'] = 'لا توجد سجلات بيانات موجودة';
                    }else{
                        $nestedData['title_fr'] = 'Aucun enregistrement de données disponible';
                    }
                }
                
                if($notice->description_ara != null){
                    $nestedData['description_ara'] = $notice->description_ara;
                }else{
                    if($language == 'ar'){
                        $nestedData['description_ara'] = 'لا توجد سجلات بيانات موجودة';
                    }else{
                        $nestedData['description_ara'] = 'Aucun enregistrement de données disponible';
                    }
                }
                
                if($notice->description_fr != null){
                    $nestedData['description_fr'] = $notice->description_fr;
                }else{
                    if($language == 'ar'){
                        $nestedData['description_fr'] = 'لا توجد سجلات بيانات موجودة';
                    }else{
                        $nestedData['description_fr'] = 'Aucun enregistrement de données disponible';
                    }
                }
                
                $nestedData['type'] = $notice->type;
                $nestedData['category_name'] = $language == 'ar' ? $notice->category_name_ara : $notice->category_name_fr;
                
                if($notice->status == 'active'){
                    if($language == 'ar'){
                        $nestedData['status'] = '<span class="badge rounded-pill bg-success">مفعل</span>';
                    }else{
                        $nestedData['status'] = '<span class="badge rounded-pill bg-success">Actif</span>';
                    }
                }else if($notice->status == 'inactive'){
                    if($language == 'ar'){
                        $nestedData['status'] = '<span class="badge rounded-pill bg-danger">غير مفعل</span>';
                    }else{
                        $nestedData['status'] = '<span class="badge rounded-pill bg-danger">Inactif</span>';
                    }
                }else{
                    if($language == 'ar'){
                        $nestedData['status'] = '<span class="badge rounded-pill bg-warning">محذوف</span>';
                    }else{
                        $nestedData['status'] = '<span class="badge rounded-pill bg-warning">Supprimé</span>';
                    }
                }
                
                $nestedData['action'] = '<button id="n_'.$notice->id.'" type="button" class="btn btn-sm btn-primary" onclick="EditNoticeModal('.$notice->id.')"><i class="fa fa-edit"></i></button>';
                $nestedData['action'] .= '<button type="button" class="btn btn-sm btn-danger" onclick="DeleteNotice('.$notice->id.')"><i class="fa fa-trash"></i></button>';
                
                $data[] = $nestedData;
            }
        }
        
        $json_data = array(
            "draw"            => intval($draw),
            "recordsTotal"    => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data"            => $data   
        );
        
        
        return Response::json($json_data);
    }
    
    //UploadVideo
    
    public function UploadVideo(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        $video = $request->file('video');
        
        if(!$video){
            if($language == 'ar'){
                $response['message'] = 'الرجاء اختيار ملف الفيديو';
            }else{
                $response['message'] = 'Please select video file';
            }
            return Response::json($response);
        }
        
        //validar el formato del video
        if($video->getClientOriginalExtension() != 'mp4'){
            if($language == 'ar'){
                $response['message'] = 'الرجاء اختيار ملف الفيديو بصيغة mp4';
            }else{
                $response['message'] = 'Please select video file with mp4 format';
            }
            return Response::json($response);
        }
        
        //obtener el tamaño máximo permitido de php
        $max_size = ini_get('upload_max_filesize');
        //Limpiar el tamaño
        $max_size = str_replace('M', '', $max_size);
        $max_size = $max_size * 1024 * 1024;
        
        
        //validar el tamaño del video
        if($video->getSize() > $max_size){
            if($language == 'ar'){
                $response['message'] = 'الرجاء اختيار ملف الفيديو بحجم اقل من 10 ميجا';
            }else{
                $response['message'] = 'Please select video file with size less than 10 MB';
            }
            return Response::json($response);
        }
        
        
        $file = $request->file('video');
        $name = time().'.'.$file->getClientOriginalExtension();
        $file->move('public/videos', $name);
        $image = 'public/videos/'.$name;
        
        //Obtener variable APP_URL
        $app_url = env('APP_URL');
        
        $response['status'] = true;
        $response['message'] = 'Video uploaded successfully';
        $response['path'] = $app_url.$image;
        
        return Response::json($response);
    }
    
}
