<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\ConsultedTimes;
use App\Models\Notice;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use Illuminate\Support\Facades\DB;

class ConsultedTimesController extends Controller
{
    public function Register(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];


        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'notice_id' => 'required|exists:notices,id',
                'device_id' => 'required',
            ],
            $messages = [
                'notice_id.required' => 'يجب إدخال الرقم التعريفي للإشعار',
                'notice_id.exists' => 'الرقم التعريفي للإشعار غير صحيح',
                'device_id.required' => 'يجب إدخال الرقم التعريفي للجهاز',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'notice_id' => 'required|exists:notices,id',
                'device_id' => 'required',
            ],
            $messages = [
                'notice_id.required' => 'Veuillez entrer le numéro d\'identification de l\'avis',
                'notice_id.exists' => 'Numéro d\'identification de l\'avis incorrect',
                'device_id.required' => 'Veuillez entrer le numéro d\'identification de l\'appareil',
            ]);
        }

        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first();
            return Response::json($response);
        }

        $consultedTimes = new ConsultedTimes();
        $consultedTimes->notices_id = $request->notice_id;
        $consultedTimes->device_id = $request->device_id;
        $consultedTimes->save();

        $notice = Notice::find($request->notice_id);
        $notice->consulted_times = $notice->consulted_times + 1;
        $notice->save();

        if($language == 'ar'){
            $message = 'تم إضافة الإشعار بنجاح';
        }else{
            $message = 'Le message a été ajouté avec succès';
        }

        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }

}
