<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Comments;
use App\Models\LikeComment;
use App\Models\Notice;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use DB;
use Carbon\Carbon;

class CommentsController extends Controller
{
    public function Register(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar')
        {
            $vld = Validator::make($request->all(), [
                'user_name' => 'required|string|max:255',
                'user_email' => 'required|string|email|max:255|email',
                'post_id' => 'required|integer|exists:notices,id',
                'body' => 'required|string|max:65535',
                'status' => 'required|in:pending,approved,rejected'
            ],
            $messages = [
                'user_name.required' => 'الاسم مطلوب',
                'user_name.string' => 'الاسم يجب ان يكون حروف',
                'user_name.max' => 'الاسم يجب ان لا يزيد عن 255 حرف',
                'user_email.required' => 'البريد الالكتروني مطلوب',
                'user_email.string' => 'البريد الالكتروني يجب ان يكون حروف',
                'user_email.email' => 'البريد الالكتروني يجب ان يكون بريد الكتروني صحيح',
                'user_email.max' => 'البريد الالكتروني يجب ان لا يزيد عن 255 حرف',
                'user_email.email' => 'البريد الالكتروني يجب ان يكون بريد الكتروني صحيح',
                'post_id.required' => 'المنشور مطلوب',
                'post_id.integer' => 'المنشور يجب ان يكون رقم',
                'post_id.exists' => 'المنشور غير موجود',
                'body.required' => 'النص مطلوب',
                'body.string' => 'النص يجب ان يكون حروف',
                'body.max' => 'النص يجب ان لا يزيد عن 65535 حرف',
                'status.required' => 'الحالة مطلوبة',
                'status.in' => 'الحالة غير صحيحة'
            ]);
        }
        else
        {
            $vld = Validator::make($request->all(), [
                'user_name' => 'required|string|max:255',
                'user_email' => 'required|string|email|max:255|email',
                'post_id' => 'required|integer|exists:notices,id',
                'body' => 'required|string|max:65535',
                'status' => 'required|in:pending,approved,rejected'
            ],
            $messages = [
                'user_name.required' => 'Le nom est requis',
                'user_name.string' => 'Le nom doit être une chaîne de caractères',
                'user_name.max' => 'Le nom ne doit pas dépasser 255 caractères',
                'user_email.required' => 'L\'email est requis',
                'user_email.string' => 'L\'email doit être une chaîne de caractères',
                'user_email.email' => 'L\'email doit être une adresse email valide',
                'user_email.max' => 'L\'email ne doit pas dépasser 255 caractères',
                'user_email.email' => 'L\'email doit être une adresse email valide',
                'post_id.required' => 'Le post est requis',
                'post_id.integer' => 'Le post doit être un nombre',
                'post_id.exists' => 'Le post n\'existe pas',
                'body.required' => 'Le texte est requis',
                'body.string' => 'Le texte doit être une chaîne de caractères',
                'body.max' => 'Le texte ne doit pas dépasser 65535 caractères',
                'status.required' => 'La statut est requis',
                'status.in' => 'La statut doit être valide'
            ]);
            
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $comment = new Comments;
        $comment->language = $language;
        $comment->user_name = $data['user_name'];
        $comment->user_email = $data['user_email'];
        $comment->post_id = $data['post_id'];
        $comment->body = $data['body'];
        $comment->status = $data['status'];
        $comment->save();
        
        $notice = Notice::find($data['post_id']);
        $notice->comments = $notice->comments + 1;
        $notice->save();
        
        if($language == 'ar'){
            $message = 'تم إضافة التعليق بنجاح';
        }else{
            $message = 'Commentaire ajouté avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function GetAll(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar')
        {
            $vld = Validator::make($request->all(), [
                'post_id' => 'required|integer|exists:notices,id',
                'status' => 'required|in:pending,approved,rejected,all',
                'device_id' => 'required|string|max:255'
            ],
            $messages = [
                'post_id.required' => 'المنشور مطلوب',
                'post_id.integer' => 'المنشور يجب ان يكون رقم',
                'post_id.exists' => 'المنشور غير موجود',
                'status.required' => 'الحالة مطلوبة',
                'status.in' => 'الحالة غير صحيحة',
                'device_id.required' => 'الجهاز مطلوب',
                'device_id.string' => 'الجهاز يجب ان يكون حروف',
                'device_id.max' => 'الجهاز يجب ان لا يزيد عن 255 حرف'
            ]);
        }
        else
        {
            $vld = Validator::make($request->all(), [
                'post_id' => 'required|integer|exists:notices,id',
                'status' => 'required|in:pending,approved,rejected,all',
                'device_id' => 'required|string|max:255'
            ],
            $messages = [
                'post_id.required' => 'Le post est requis',
                'post_id.integer' => 'Le post doit être un nombre',
                'post_id.exists' => 'Le post n\'existe pas',
                'status.required' => 'La statut est requis',
                'status.in' => 'La statut doit être valide',
                'device_id.required' => 'Le device_id est requis',
                'device_id.string' => 'Le device_id doit être une chaîne de caractères',
                'device_id.max' => 'Le device_id ne doit pas dépasser 255 caractères'
            ]);
            
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if($data['status'] == 'all')
        {
            $comments = Comments::where('post_id', $data['post_id'])
            //->where('language', $language)
            ->get();
        }
        else
        {
            $comments = Comments::where('post_id', $data['post_id'])
            ->where('status', $data['status'])
            //->where('language', $language)
            ->get();
        }
        
        for($i = 0; $i < count($comments); $i++) {
            $comments[$i]->date_fr = Carbon::parse($comments[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $comments[$i]->date_ar = Carbon::parse($comments[$i]->created_at)->locale('ar')->isoFormat('LLLL');
            
            //Buscar los likes del comentario basado en el device_id
            $likes = LikeComment::where('comments_id', $comments[$i]->id)
            ->where('device_id', $data['device_id'])
            ->get();
            
            if(count($likes) > 0)
            {
                if($likes[0]->type == 'like')
                {
                    $comments[$i]->type = 'like';
                }
                else
                {
                    $comments[$i]->type = 'dislike';
                }
            }
            else
            {
                $comments[$i]->type = 'none';
            }
            
        }
        
        if($comments->isEmpty()) {
            if($language == 'ar'){
                $message = 'لا يوجد تعليقات';
            }else{
                $message = 'Aucun commentaire';
            }
            $response['status'] = true;
            $response['data'] = false;
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            $message = 'تم إضافة التعليقات بنجاح';
        }else{
            $message = 'Commentaires ajoutés avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $comments;
        return Response::json($response);
        
    }
    
    public function Update(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar')
        {
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:comments,id',
                'status' => 'required|in:pending,approved,rejected'
            ],
            $messages = [
                'id.required' => 'التعليق مطلوب',
                'id.integer' => 'التعليق يجب ان يكون رقم',
                'id.exists' => 'التعليق غير موجود',
                'status.required' => 'الحالة مطلوبة',
                'status.in' => 'الحالة غير صحيحة'
            ]);
        }
        else
        {
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:comments,id',
                'status' => 'required|in:pending,approved,rejected'
            ],
            $messages = [
                'id.required' => 'Le commentaire est requis',
                'id.integer' => 'Le commentaire doit être un nombre',
                'id.exists' => 'Le commentaire n\'existe pas',
                'status.required' => 'Le statut est requis',
                'status.in' => 'Le statut doit être valide'
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $comment = Comments::find($data['id']);
        $comment->status = $data['status'];
        $comment->save();
        
        if($language == 'ar'){
            $message = 'تم تعديل التعليق بنجاح';
        }else{
            $message = 'Commentaire modifié avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function RegisterLike(Request $request)
    {
        
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar')
        {
            $vld = Validator::make($request->all(), [
                'comments_id' => 'required|exists:comments,id',
                'device_id' => 'required',
                'type' => 'required|in:like,dislike',
            ],
            $messages = [
                'comments_id.required' => 'التعليق مطلوب',
                'comments_id.exists' => 'التعليق غير موجود',
                'device_id.required' => 'الجهاز مطلوب',
                'type.required' => 'النوع مطلوب',
                'type.in' => 'النوع غير صحيح'
            ]);
        }
        else
        {
            $vld = Validator::make($request->all(), [
                'comments_id' => 'required|exists:comments,id',
                'device_id' => 'required',
                'type' => 'required|in:like,dislike',
            ],
            $messages = [
                'comments_id.required' => 'Le commentaire est requis',
                'comments_id.exists' => 'Le commentaire n\'existe pas',
                'device_id.required' => 'Le périphérique est requis',
                'type.required' => 'Le type est requis',
                'type.in' => 'Le type doit être valide'
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        /*Si el dispositivo repite el like o dislike*/
        $like = LikeComment::where('comments_id', $data['comments_id'])
        ->where('device_id', $data['device_id'])
        ->where('type', $data['type'])
        ->first();
        
        if($like)
        {
            
            $like->delete();
            
            $comment = Comments::find($data['comments_id']);
            if($data['type'] == 'like')
            {
                $comment->like = $comment->like - 1;
            }
            else
            {
                $comment->dislike = $comment->dislike - 1;
            }
            
            $comment->save();
            
            $comment->type = 'none';
            
            if($language == 'ar'){
                $message = 'تمت العملية بنجاح';
            }else{
                $message = 'La requête a été effectuée avec succès';
            }
            
            $response['status'] = true;
            $response['message'] = $message;
            $response['data'] = $comment;
            return Response::json($response);
            
        }else{
            ////////////////////////////////////////////////////////////////////////////////////////////////
            
            ////////////////////////////////////////////////////////////////////////////////////////////////
            /*Si el dispositivo tiene un like en el comentario tiene diferente al que se esta votando*/
            $like = LikeComment::where('comments_id', $data['comments_id'])
            ->where('device_id', $data['device_id'])
            ->where('type', '!=', $data['type'])
            ->first();
            
            if($like)
            {
                $like->delete();
                $comment = Comments::find($data['comments_id']);
                if($data['type'] == 'like')
                {
                    $comment->dislike = $comment->dislike - 1;
                }
                else
                {
                    $comment->like = $comment->like - 1;
                }
                $comment->save();
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////
            
            
            ////////////////////////////////////////////////////////////////////////////////////////////////
            /*Si el dispositivo no tiene ningun like o dislike en el comentario*/
            $like = new LikeComment();
            $like->comments_id = $data['comments_id'];
            $like->device_id = $data['device_id'];
            $like->type = $data['type'];
            $like->save();
            
            $comment = Comments::find($data['comments_id']);
            if($data['type'] == 'like')
            {
                $comment->like = $comment->like + 1;
            }
            else
            {
                $comment->dislike = $comment->dislike + 1;
            }
            $comment->save();
            
            $comment->type = $data['type'];
            ////////////////////////////////////////////////////////////////////////////////////////////////
            
            
            if($language == 'ar'){
                $message = 'تمت العملية بنجاح';
            }else{
                $message = 'La requête a été effectuée avec succès';
            }
            
            $response['status'] = true;
            $response['message'] = $message;
            $response['data'] = $comment;
            return Response::json($response);
        }
    }
    
}
