<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Notice;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CategoryController extends Controller
{
    
    public function Register(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'name_ara' => 'required|string|max:255',
                'name_fr' => 'required|string|max:255',
                'icon' => 'required|string|max:255',
                'text_color' => 'required|string|max:7',
                'icon_color' => 'required|string|max:7',
                'status' => 'required|in:true,false',
            ],
            $messages = [
                'name_ara.required' => 'الحقل الأول مطلوب.',
                'name_ara.string' => 'الحقل الأول يجب أن يكون سلسلة الحروف.',
                'name_ara.max' => 'الحقل الأول يجب أن لا يزيد عن 255 حرف.',
                'name_fr.required' => 'الحقل الثاني مطلوب.',
                'name_fr.string' => 'الحقل الثاني يجب أن يكون سلسلة الحروف.',
                'name_fr.max' => 'الحقل الثاني يجب أن لا يزيد عن 255 حرف.',
                'icon.required' => 'الحقل الثالث مطلوب.',
                'icon.string' => 'الحقل الثالث يجب أن يكون سلسلة الحروف.',
                'icon.max' => 'الحقل الثالث يجب أن لا يزيد عن 255 حرف.',
                'text_color.required' => 'الحقل الرابع مطلوب.',
                'text_color.string' => 'الحقل الرابع يجب أن يكون سلسلة الحروف.',
                'text_color.max' => 'الحقل الرابع يجب أن لا يزيد عن 7 حرف.',
                'icon_color.required' => 'الحقل الخامس مطلوب.',
                'icon_color.string' => 'الحقل الخامس يجب أن يكون سلسلة الحروف.',
                'icon_color.max' => 'الحقل الخامس يجب أن لا يزيد عن 7 حرف.',
                'status.required' => 'الحقل الرابع مطلوب.',
                'status.in' => 'الحقل الرابع يجب أن يكون بين true و false.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'name_ara' => 'required|string|max:255',
                'name_fr' => 'required|string|max:255',
                'icon' => 'required|string|max:255',
                'text_color' => 'required|string|max:7',
                'icon_color' => 'required|string|max:7',
                'status' => 'required|in:true,false',
            ],
            $messages = [
                'name_ara.required' => 'Le premier champ est obligatoire.',
                'name_ara.string' => 'Le premier champ doit être une chaîne de caractères.',
                'name_ara.max' => 'Le premier champ ne doit pas dépasser 255 caractères.',
                'name_fr.required' => 'Le second champ est obligatoire.',
                'name_fr.string' => 'Le second champ doit être une chaîne de caractères.',
                'name_fr.max' => 'Le second champ ne doit pas dépasser 255 caractères.',
                'icon.required' => 'Le troisième champ est obligatoire.',
                'icon.string' => 'Le troisième champ doit être une chaîne de caractères.',
                'icon.max' => 'Le troisième champ ne doit pas dépasser 255 caractères.',
                'text_color.required' => 'Le quatrième champ est obligatoire.',
                'text_color.string' => 'Le quatrième champ doit être une chaîne de caractères.',
                'text_color.max' => 'Le quatrième champ ne doit pas dépasser 7 caractères.',
                'icon_color.required' => 'Le cinquième champ est obligatoire.',
                'icon_color.string' => 'Le cinquième champ doit être une chaîne de caractères.',
                'icon_color.max' => 'Le cinquième champ ne doit pas dépasser 7 caractères.',
                'status.required' => 'Le quatrième champ est obligatoire.',
                'status.in' => 'Le quatrième champ doit être entre true et false.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first();
            return Response::json($response);
        }
        
        $category = new Category();
        $category->name_ara = $data['name_ara'];
        $category->name_fr = $data['name_fr'];
        $category->icon = $data['icon'];
        $category->text_color = $data['text_color'];
        $category->icon_color = $data['icon_color'];
        $category->status = $data['status'] == 'true' ? true : false;
        $category->save();
        
        $categories = Category::select('id', 'order')->get();
        
        foreach ($categories as $category_order) {
            $category_order->order = $category_order->order + 1;
            $category_order->save();
        }
        
        if($language == 'ar'){
            $message = 'تم تعديل الفئة بنجاح.';
        }else{
            $message = 'Catégorie modifiée avec succès.';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function Update(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer',
                'name_ara' => 'required|string|max:255',
                'name_fr' => 'required|string|max:255',
                'icon' => 'required|string|max:255',
                'text_color' => 'required|string|max:7',
                'icon_color' => 'required|string|max:7',
                'status' => 'required|in:true,false',
            ],
            $messages = [
                'id.required' => 'الحقل الأول مطلوب.',
                'id.integer' => 'الحقل الأول يجب أن يكون رقماً.',
                'name_ara.required' => 'الحقل الأول مطلوب.',
                'name_ara.string' => 'الحقل الأول يجب أن يكون سلسلة الحروف.',
                'name_ara.max' => 'الحقل الأول يجب أن لا يزيد عن 255 حرف.',
                'name_fr.required' => 'الحقل الثاني مطلوب.',
                'name_fr.string' => 'الحقل الثاني يجب أن يكون سلسلة الحروف.',
                'name_fr.max' => 'الحقل الثاني يجب أن لا يزيد عن 255 حرف.',
                'icon.required' => 'الحقل الثالث مطلوب.',
                'icon.string' => 'الحقل الثالث يجب أن يكون سلسلة الحروف.',
                'icon.max' => 'الحقل الثالث يجب أن لا يزيد عن 255 حرف.',
                'text_color.required' => 'الحقل الرابع مطلوب.',
                'text_color.string' => 'الحقل الرابع يجب أن يكون سلسلة الحروف.',
                'text_color.max' => 'الحقل الرابع يجب أن لا يزيد عن 7 حرف.',
                'icon_color.required' => 'الحقل الخامس مطلوب.',
                'icon_color.string' => 'الحقل الخامس يجب أن يكون سلسلة الحروف.',
                'icon_color.max' => 'الحقل الخامس يجب أن لا يزيد عن 7 حرف.',
                'status.required' => 'الحقل الرابع مطلوب.',
                'status.in' => 'الحقل الرابع يجب أن يكون بين true و false.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer',
                'name_ara' => 'required|string|max:255',
                'name_fr' => 'required|string|max:255',
                'icon' => 'required|string|max:255',
                'text_color' => 'required|string|max:7',
                'icon_color' => 'required|string|max:7',
                'status' => 'required|in:true,false',
            ],
            $messages = [
                'id.required' => 'Le premier champ est obligatoire.',
                'id.integer' => 'Le premier champ doit être une chaîne de caractères.',
                'name_ara.required' => 'Le premier champ est obligatoire.',
                'name_ara.string' => 'Le premier champ doit être une chaîne de caractères.',
                'name_ara.max' => 'Le premier champ ne doit pas dépasser 255 caractères.',
                'name_fr.required' => 'Le second champ est obligatoire.',
                'name_fr.string' => 'Le second champ doit être une chaîne de caractères.',
                'name_fr.max' => 'Le second champ ne doit pas dépasser 255 caractères.',
                'icon.required' => 'Le troisième champ est obligatoire.',
                'icon.string' => 'Le troisième champ doit être une chaîne de caractères.',
                'icon.max' => 'Le troisième champ ne doit pas dépasser 255 caractères.',
                'text_color.required' => 'Le quatrième champ est obligatoire.',
                'text_color.string' => 'Le quatrième champ doit être une chaîne de caractères.',
                'text_color.max' => 'Le quatrième champ ne doit pas dépasser 7 caractères.',
                'icon_color.required' => 'Le cinquième champ est obligatoire.',
                'icon_color.string' => 'Le cinquième champ doit être une chaîne de caractères.',
                'icon_color.max' => 'Le cinquième champ ne doit pas dépasser 7 caractères.',
                'status.required' => 'Le quatrième champ est obligatoire.',
                'status.in' => 'Le quatrième champ doit être entre true et false.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $category = Category::find($data['id']);
        $category->name_ara = $data['name_ara'];
        $category->name_fr = $data['name_fr'];
        $category->icon = $data['icon'];
        $category->text_color = $data['text_color'];
        $category->icon_color = $data['icon_color'];
        $category->status = $data['status'] == 'true' ? true : false;
        $category->save();
        
        if($language == 'ar'){
            $message = 'تم تعديل الفئة بنجاح.';
        }else{
            $message = 'Catégorie modifiée avec succès.';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function Delete(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:categories,id',
            ],
            $messages = [
                'id.required' => 'الحقل الأول مطلوب.',
                'id.integer' => 'الحقل الأول يجب أن يكون رقماً.',
                'id.exists' => 'الحقل الأول يجب أن يكون رقماً.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:categories,id',
            ],
            $messages = [
                'id.required' => 'Le premier champ est obligatoire.',
                'id.integer' => 'Le premier champ doit être une chaîne de caractères.',
                'id.exists' => 'Le premier champ doit être une chaîne de caractères.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $category = Category::find($data['id']);
        $category->delete();
        
        $category = Category::find($data['id']);
        $order = $category->order;
        $category->delete();
        
        $categories = Category::select('id','order')->where('order','>',$order)->get();
        
        foreach($categories as $category){
            $category->order = $category->order - 1;
            $category->save();
        }
        
        if($language == 'ar'){
            $message = 'تم حذف الفئة بنجاح.';
        }else{
            $message = 'Catégorie supprimée avec succès.';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);
    }
    
    public function GetAll(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:true,false,both',
            ],
            $messages = [
                'status.required' => 'الحقل الأول مطلوب.',
                'status.in' => 'الحقل الأول يجب أن يكون بين true و false.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:true,false,both',
            ],
            $messages = [
                'status.required' => 'Le premier champ est obligatoire.',
                'status.in' => 'Le premier champ doit être entre true et false.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if ($data['status'] == 'both') {
            $categories = Category::select('*')
            ->orderBy('order', 'asc')
            ->get();
        } else {
            $categories = Category::where('status', $data['status'] == 'true' ? 1 : 0)
            ->orderBy('order', 'asc')
            ->get();
        }
        
        if(!$categories->count()) {
            if($language == 'ar'){
                $message = 'لا يوجد فئات.';
            }else{
                $message = 'Aucune catégorie.';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        if($language == 'ar'){
            $message = 'تم جلب الفئات بنجاح.';
        }else{
            $message = 'Catégories récupérées avec succès.';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $categories;
        return Response::json($response);
    }
    
    public function GetLastRegisterWithCountNotices(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:true,false,both',
            ],
            $messages = [
                'status.required' => 'الحقل الأول مطلوب.',
                'status.in' => 'الحقل الأول يجب أن يكون بين true و false.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'status' => 'required|in:true,false,both',
            ],
            $messages = [
                'status.required' => 'Le premier champ est obligatoire.',
                'status.in' => 'Le premier champ doit être entre true et false.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if ($data['status'] == 'both') {
            $categories = DB::table('categories')
            ->join('notices', 'categories.id', '=', 'notices.category_id')
            ->select('categories.*', DB::raw('count(notices.id) as notices_count'))
            ->groupBy('categories.id')
            ->orderBy('categories.id', 'desc')
            ->get();
        } else {
            $categories = 
            DB::table('categories')
            ->join('notices', 'categories.id', '=', 'notices.category_id')
            ->select('categories.*', DB::raw('count(notices.id) as notices_count'))
            ->where('categories.status', $data['status'] == 'true' ? 1 : 0)
            ->groupBy('categories.id')
            ->orderBy('categories.id', 'desc')
            ->get();
        }
        
        for($i = 0; $i < count($categories); $i++) {
            $categories[$i]->date_fr = Carbon::parse($categories[$i]->created_at)->locale('fr')->isoFormat('LLLL');
            $categories[$i]->date_ar = Carbon::parse($categories[$i]->created_at)->locale('ar')->isoFormat('LLLL');
        }
        
        if(!$categories->count()) {
            if($language == 'ar'){
                $message = 'لا يوجد فئات.';
            }else{
                $message = 'Aucune catégorie.';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            $message = 'تم جلب الفئات بنجاح.';
        }else{
            $message = 'Catégories récupérées avec succès.';
        }
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $categories;
        return Response::json($response);
    }
    
    public function GetById(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:categories,id',
            ],
            $messages = [
                'id.required' => 'الحقل الأول مطلوب.',
                'id.integer' => 'الحقل الأول يجب أن يكون بين true و false.',
                'id.exists' => 'الحقل الأول يجب أن يكون بين true و false.',
            ]);
        }else{
            $vld = Validator::make($request->all(), [
                'id' => 'required|integer|exists:categories,id',
            ],
            $messages = [
                'id.required' => 'Le premier champ est obligatoire.',
                'id.integer' => 'Le premier champ doit être entre true et false.',
                'id.exists' => 'Le premier champ doit être entre true et false.',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $category = Category::find($data['id']);
        
        if(!$category) {
            if($language == 'ar'){
                $message = 'لا يوجد فئة بهذا الرقم.';
            }else{
                $message = 'Aucune catégorie avec ce numéro.';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        
        if($language == 'ar'){
            $message = 'تم إخطار التصنيف بنجاح';
        }else{
            $message = 'Catégorie notifiée avec succès';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $category;
        return Response::json($response);
    }

    public function UpdateOrder(Request $request){
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        for($i = 0; $i < count($data)-1; $i++) {
            $category = Category::find($data[$i]['id']);
            $category->order = $data[$i]['order'];
            $category->save();
        }
        
        if($language == 'ar'){
            $message = 'تم التعديل بنجاح';
        }else{
            $message = 'Modification réussie';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        return Response::json($response);

    }

    public function GetAllDatatableServerSide (Request $request) {
        sleep(1);
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $columns = array( 
            0 => 'order',
            1 => 'name_ara',
            2 => 'name_fr',
            3 => 'icon',
            4 => 'status'
        );
        
        $totalData = Category::count();
        
        $totalFiltered = $totalData;
        
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        
        if(empty($request->input('search.value')))
        {            
            $categories = Category::offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
        }
        else {
            $search = $request->input('search.value'); 
            
            $categories =  Category::where('name_ara','LIKE',"%{$search}%")
            ->orWhere('name_fr','LIKE',"%{$search}%")
            ->orWhere('icon','LIKE',"%{$search}%")
            ->offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
            
            $totalFiltered = Category::where('name_ara','LIKE',"%{$search}%")
            ->orWhere('name_fr','LIKE',"%{$search}%")
            ->orWhere('icon','LIKE',"%{$search}%")
            ->count();
        }
        
        $draw = $request->input('draw');
        $data = array();
        
        if(!empty($categories))
        {
            foreach ($categories as $category)
            {
                $nestedData['order'] = $category->order;
                $nestedData['name_ara'] = $category->name_ara;
                $nestedData['name_fr'] = $category->name_fr;
                $nestedData['icon'] = '<i class="'.$category->icon.'"></i>';
                
                if($category->status == '1'){
                    if($language == 'ar'){
                        $nestedData['status'] = '<span class="badge rounded-pill bg-success">مفعل</span>';
                    }else{
                        $nestedData['status'] = '<span class="badge rounded-pill bg-success">Actif</span>';
                    }
                }else{
                    if($language == 'ar'){
                        $nestedData['status'] = '<span class="badge rounded-pill bg-danger">غير مفعل</span>';
                    }else{
                        $nestedData['status'] = '<span class="badge rounded-pill bg-danger">Inactif</span>';
                    }
                }
                $nestedData['action'] = '<button id="n_'.$category->id.'" type="button" class="btn btn-sm btn-primary" onclick="EditCategoryModal('.$category->id.')"><i class="fa fa-edit"></i></button>';
                $nestedData['action'] .= '<button type="button" class="btn btn-sm btn-danger" onclick="DeleteCategory('.$category->id.')"><i class="fa fa-trash"></i></button>';
                $data[] = $nestedData;
            }
        }
        
        $json_data = array(
            "draw"            => intval($draw),
            "recordsTotal"    => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data"            => $data   
        );
        
        return Response::json($json_data);
    }
    
}
