<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Professional;
use App\Models\Category;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Response;

use Hash;
use Auth;

class AuthController extends Controller
{
    
    public function registerUser (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'name' => ['required', 'string', 'max:100'],
                'email' => ['required', 'string', 'email', 'max:100','unique:users'],
                'password' => ['required', 'string', 'min:8'],
                'language' => ['required', 'string', Rule::in(['ar', 'fr'])],
            ],
            $messages = [
                'name.required' => 'يجب إدخال الاسم',
                'name.string' => 'يجب إدخال الاسم بشكل صحيح',
                'name.max' => 'يجب ألا يتجاوز الاسم 100 حرفا',
                'email.required' => 'يجب إدخال البريد الإلكتروني',
                'email.string' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.email' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.max' => 'يجب ألا يتجاوز البريد الإلكتروني 100 حرفا',
                'email.unique' => 'هذا البريد الإلكتروني مسجل مسبقا',
                'password.required' => 'يجب إدخال كلمة المرور',
                'password.string' => 'يجب إدخال كلمة المرور بشكل صحيح',
                'password.min' => 'يجب ألا يقل كلمة المرور عن 8 أحرف',
                'language.required' => 'يجب إدخال اللغة',
                'language.string' => 'يجب إدخال اللغة بشك',
                'language.in' => 'يجب إدخال اللغة بشكل صحيح',
            ]);
        }else{
            $vld = Validator::make($data, [
                'name' => ['required', 'string', 'max:100'],
                'email' => ['required', 'string', 'email', 'max:100','unique:users'],
                'password' => ['required', 'string', 'min:8'],
                'language' => ['required', 'string', Rule::in(['ar', 'fr'])],
            ],
            $messages = [
                'name.required' => 'Vous devez entrer votre nom',
                'name.string' => 'Vous devez entrer votre nom avec un format correct',
                'name.max' => 'Vous devez entrer votre nom avec un maximum de 100 caractères',
                'email.required' => 'Vous devez entrer votre email',
                'email.string' => 'Vous devez entrer votre email avec un format correct',
                'email.email' => 'Vous devez entrer votre email avec un format correct',
                'email.max' => 'Vous devez entrer votre email avec un maximum de 100 caractères',
                'email.unique' => 'Cet email est déjà utilisé',
                'password.required' => 'Vous devez entrer votre mot de passe',
                'password.string' => 'Vous devez entrer votre mot de passe avec un format correct',
                'password.min' => 'Vous devez entrer votre mot de passe avec un minimum de 8 caractères',
                'language.required' => 'Vous devez entrer votre langue',
                'language.string' => 'Vous devez entrer votre langue avec un format correct',
                'language.in' => 'Vous devez entrer votre langue avec un format correct',
                
            ]);
        }
        
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $user = new User();
        $user->name = $data['name'];
        $user->email = $data['email'];
        $user->password = Hash::make($data['password']);
        $user->language = $data['language'];
        
        $user->save();
        
        $response['status'] = true;
        if($language == 'ar'){
            $response['message'] = 'تم التسجيل بنجاح';
        }else{
            $response['message'] = 'Inscription réussie';
        }

        return Response::json($response);
        
    }
    
    
    public function loginUser (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'password' => ['required', 'string', 'min:8'],
            ],
            $messages = [
                'email.required' => 'يجب إدخال البريد الإلكتروني',
                'email.string' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.email' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.max' => 'يجب ألا يتجاوز البريد الإلكتروني 100 حرفا',
                'password.required' => 'يجب إدخال كلمة المرور',
                'password.string' => 'يجب إدخال كلمة المرور بشكل صحيح',
                'password.min' => 'يجب ألا يقل كلمة المرور عن 8 أحرف',
            ]);
        }else{
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'password' => ['required', 'string', 'min:8'],
            ],
            $messages = [
                'email.required' => 'Vous devez entrer votre email',
                'email.string' => 'Vous devez entrer votre email avec un format correct',
                'email.email' => 'Vous devez entrer votre email avec un format correct',
                'email.max' => 'Vous devez entrer votre email avec un maximum de 100 caractères',
                'password.required' => 'Vous devez entrer votre mot de passe',
                'password.string' => 'Vous devez entrer votre mot de passe avec un format correct',
                'password.min' => 'Vous devez entrer votre mot de passe avec un minimum de 8 caractères',
            ]);
        }
        
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first();
            return Response::json($response);
        };
        
        $user = User::where('email', $data['email'])->first();
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'البريد الإلكتروني غير مسجل';
            } else {
                $response['message'] = 'email non enregistré';
            }
            return Response::json($response);
        }
        
        if (!Hash::check($data['password'], $user->password)) {
            if ($language == 'ar') {
                $response['message'] = 'كلمة المرور غير صحيحة';
            } else {
                $response['message'] = 'mot de passe incorrect';
            }
            return Response::json($response);
        }
        
        $credentials = [
            'email' => $data['email'],
            'password' => $data['password']
        ];
        
        if (!Auth::attempt($credentials)) {
            if ($language == 'ar') {
                $response['message'] = 'البريد الإلكتروني غير مسجل';
            } else {
                $response['message'] = 'email non enregistré';
            }
            return Response::json($response);
        }else{
            
            $response['status'] = true;
            if ($language == 'ar') {
                $response['message'] = 'تم التسجيل بنجاح';
            } else {
                $response['message'] = 'inscription réussi';
            }
            session()->put('locale', $user->language);
            $response['user'] = Auth::user();
            return Response::json($response);
        }
    }
    
    public function UpdatePassword (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'old_password' => ['required', 'string', 'min:8'],
                'new_password' => ['required', 'string', 'min:8',],
                'confirm_password' => ['required', 'string', 'min:8',],
            ],
            $messages = [
                'old_password.required' => 'يجب إدخال كلمة المرور القديمة',
                'old_password.string' => 'يجب إدخال كلمة المرور القديمة بشكل صحيح',
                'old_password.min' => 'يجب ألا يقل كلمة المرور القديمة عن 8 أحرف',
                'new_password.required' => 'يجب إدخال كلمة المرور الجديدة',
                'new_password.string' => 'يجب إدخال كلمة المرور الجديدة بشكل صحيح',
                'new_password.min' => 'يجب ألا يقل كلمة المرور الجديدة عن 8 أحرف',
                'confirm_password.required' => 'يجب إدخال تأكيد كلمة المرور',
                'confirm_password.string' => 'يجب إدخال تأكيد كلمة المرور بشكل صحيح',
                'confirm_password.min' => 'يجب ألا يقل تأكيد كلمة المرور عن 8 أحرف',
            ]);
        }else{
            $vld = Validator::make($data, [
                'old_password' => ['required', 'string', 'min:8'],
                'new_password' => ['required', 'string', 'min:8',],
                'confirm_password' => ['required', 'string', 'min:8',],
            ],
            $messages = [
                'old_password.required' => 'Vous devez entrer votre mot de passe actuel',
                'old_password.string' => 'Vous devez entrer votre mot de passe actuel avec un format correct',
                'old_password.min' => 'Vous devez entrer votre mot de passe actuel avec un minimum de 8 caractères',
                'new_password.required' => 'Vous devez entrer votre nouveau mot de passe',
                'new_password.string' => 'Vous devez entrer votre nouveau mot de passe avec un format correct',
                'new_password.min' => 'Vous devez entrer votre nouveau mot de passe avec un minimum de 8 caractères',
                'confirm_password.required' => 'Vous devez entrer votre nouveau mot de passe',
                'confirm_password.string' => 'Vous devez entrer votre nouveau mot de passe avec un format correct',
                'confirm_password.min' => 'Vous devez entrer votre nouveau mot de passe avec un minimum de 8 caractères',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first();
            return Response::json($response);
        };
        
        $user = User::find(Auth::user()->id);
        
        if (!Hash::check($data['old_password'], $user->password)) {
            if ($language == 'ar') {
                $response['message'] = 'كلمة المرور القديمة غير صحيحة';
            } else {
                $response['message'] = 'ancien mot de passe incorrect';
            }
            return Response::json($response);
        }
        
        if ($data['new_password'] != $data['confirm_password']) {
            if ($language == 'ar') {
                $response['message'] = 'كلمة المرور غير متطابقة';
            } else {
                $response['message'] = 'les mots de passe ne sont pas identiques';
            }
            return Response::json($response);
        }
        
        $user->password = Hash::make($data['new_password']);
        $user->save();
        
        $response['status'] = true;
        if ($language == 'ar') {
            $response['message'] = 'تم تحديث كلمة المرور بنجاح';
        } else {
            $response['message'] = 'mot de passe mis à jour avec succès';
        }
        return Response::json($response);
        
    }
    
    public function UpdateUser (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'name' => ['required', 'string', 'max:100'],
            ],
            $messages = [
                'email.required' => 'يجب إدخال البريد الإلكتروني',
                'email.string' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.email' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.max' => 'يجب ألا يتجاوز البريد الإلكتروني 100 حرف',
                'name.required' => 'يجب إدخال الاسم',
                'name.string' => 'يجب إدخال الاسم بشكل صحيح',
                'name.max' => 'يجب ألا يتجاوز الاسم 100 حرف',
            ]);
        }else{
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'name' => ['required', 'string', 'max:100'],
            ],
            $messages = [
                'email.required' => 'Vous devez entrer votre adresse email',
                'email.string' => 'Vous devez entrer votre adresse email avec un format correct',
                'email.email' => 'Vous devez entrer votre adresse email avec un format correct',
                'email.max' => 'Vous devez entrer votre adresse email avec un maximum de 100 caractères',
                'name.required' => 'Vous devez entrer votre nom',
                'name.string' => 'Vous devez entrer votre nom avec un format correct',
                'name.max' => 'Vous devez entrer votre nom avec un maximum de 100 caractères',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if (!Auth::check()) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        $user = User::where('email', $data['email'])->first();
        if ($user && $user->id != Auth::user()->id) {
            if ($language == 'ar') {
                $response['message'] = 'البريد الإلكتروني مسجل مسبقا';
            } else {
                $response['message'] = 'email déjà enregistré';
            }
            return Response::json($response);
        }
        
        $user = User::find(Auth::user()->id);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        $user->name = $data['name'];
        $user->email = $data['email'];
        $user->save();
        
        $response['status'] = true;
        $response['user'] = $user;
        if ($language == 'ar') {
            $response['message'] = 'تم تحديث البيانات بنجاح';
        } else {
            $response['message'] = 'les données mis à jour avec succès';
        }
        return Response::json($response);
    }

    //UpdateUserById
    public function UpdateUserById (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'name' => ['required', 'string', 'max:100'],
                'id' => ['required', 'integer','exists:users,id'],
            ],
            $messages = [
                'email.required' => 'يجب إدخال البريد الإلكتروني',
                'email.string' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.email' => 'يجب إدخال البريد الإلكتروني بشكل صحيح',
                'email.max' => 'يجب ألا يتجاوز البريد الإلكتروني 100 حرف',
                'name.required' => 'يجب إدخال الاسم',
                'name.string' => 'يجب إدخال الاسم بشكل صحيح',
                'name.max' => 'يجب ألا يتجاوز الاسم 100 حرف',
                'id.required' => 'يجب إدخال رقم المستخدم',
                'id.integer' => 'يجب إدخال رقم المستخدم بشكل صحيح',
                'id.exists' => 'رقم المستخدم غير موجود',
            ]);
        }else{
            $vld = Validator::make($data, [
                'email' => ['required', 'string', 'email', 'max:100'],
                'name' => ['required', 'string', 'max:100'],
                'id' => ['required', 'integer','exists:users,id'],
            ],
            $messages = [
                'email.required' => 'Vous devez entrer votre adresse email',
                'email.string' => 'Vous devez entrer votre adresse email avec un format correct',
                'email.email' => 'Vous devez entrer votre adresse email avec un format correct',
                'email.max' => 'Vous devez entrer votre adresse email avec un maximum de 100 caractères',
                'name.required' => 'Vous devez entrer votre nom',
                'name.string' => 'Vous devez entrer votre nom avec un format correct',
                'name.max' => 'Vous devez entrer votre nom avec un maximum de 100 caractères',
                'id.required' => 'Vous devez entrer l\'id de l\'utilisateur',
                'id.integer' => 'Vous devez entrer l\'id de l\'utilisateur avec un format correct',
                'id.exists' => 'l\'id de l\'utilisateur n\'existe pas',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if (!Auth::check()) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        $user = User::where('email', $data['email'])->where('id', '!=', $data['id'])->first();
        if ($user) {
            if ($language == 'ar') {
                $response['message'] = 'البريد الإلكتروني مسجل مسبقا';
            } else {
                $response['message'] = 'email déjà enregistré';
            }
            return Response::json($response);
        }
        
        $user = User::find($data['id']);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }

        $user->name = $data['name'];
        $user->email = $data['email'];
        $user->save();

        $response['status'] = true;
        $response['user'] = $user;
        if ($language == 'ar') {
            $response['message'] = 'تم تحديث البيانات بنجاح';
        } else {
            $response['message'] = 'les données mis à jour avec succès';
        }
        return Response::json($response);
    }

    //DeleteUserById
    public function DeleteUserById (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'id' => ['required', 'integer','exists:users,id'],
            ],
            $messages = [
                'id.required' => 'يجب إدخال رقم المستخدم',
                'id.integer' => 'يجب إدخال رقم المستخدم بشكل صحيح',
                'id.exists' => 'رقم المستخدم غير موجود',
            ]);
        }else{
            $vld = Validator::make($data, [
                'id' => ['required', 'integer','exists:users,id'],
            ],
            $messages = [
                'id.required' => 'Vous devez entrer l\'id de l\'utilisateur',
                'id.integer' => 'Vous devez entrer l\'id de l\'utilisateur avec un format correct',
                'id.exists' => 'l\'id de l\'utilisateur n\'existe pas',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if (!Auth::check()) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        $user = User::find($data['id']);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }

        //Si el usuario es el de id 1, no se puede eliminar
        if ($user->id == 1) {
            if ($language == 'ar') {
                $response['message'] = 'لا يمكن حذف المستخدم الرئيسي';
            } else {
                $response['message'] = 'Impossible de supprimer l\'utilisateur principal';
            }
            return Response::json($response);
        }

        $user->delete();

        $response['status'] = true;
        if ($language == 'ar') {
            $response['message'] = 'تم حذف المستخدم بنجاح';
        } else {
            $response['message'] = 'l\'utilisateur supprimé avec succès';
        }
        return Response::json($response);
    }
    
    public function updateLanguage(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'language' => ['required', 'string', Rule::in(['ar', 'fr'])],
            ],
            $messages = [
                'language.required' => 'يجب إدخال اللغة',
                'language.string' => 'يجب إدخال اللغة بشكل صحيح',
                'language.in' => 'يجب إدخال اللغة بشكل صحيح',
            ]);
        }else{
            $vld = Validator::make($data, [
                'language' => ['required', 'string', Rule::in(['ar', 'fr'])],
            ],
            $messages = [
                'language.required' => 'Vous devez entrer la langue',
                'language.string' => 'Vous devez entrer la langue avec un format correct',
                'language.in' => 'Vous devez entrer la langue avec un format correct',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        if (!Auth::check()) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        $user = User::find(Auth::user()->id);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        session()->put('locale', $data['language']);
        
        $user->language = $data['language'];
        $user->save();
        
        $response['status'] = true;
        $response['user'] = $user;
        if ($language == 'ar') {
            $response['message'] = 'تم تحديث اللغة بنجاح';
        } else {
            $response['message'] = 'la langue a été mise à jour avec succès';
        }
        return Response::json($response);
    }
    
    
    public function logoutUser (Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        $user = User::find(Auth::user()->id);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'الرجاء التسجيل';
            } else {
                $response['message'] = 'veuillez vous connecter';
            }
            return Response::json($response);
        }
        
        Auth::logout();
        
        $response['status'] = true;
        if ($language == 'ar') {
            $response['message'] = 'تم تسجيل الخروج بنجاح';
        } else {
            $response['message'] = 'déconnexion réussie';
        }
        return Response::json($response);        
    }

    public function GetUserById(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        $language = $data['language'];
        
        if($language == 'ar'){
            $vld = Validator::make($data, [
                'id' => 'required|integer',
            ],
            $messages = [
                'id.required' => 'يجب إدخال رقم المستخدم',
                'id.integer' => 'يجب إدخال رقم المستخدم بشكل صحيح',
            ]);
        }else{
            $vld = Validator::make($data, [
                'id' => 'required|integer',
            ],
            $messages = [
                'id.required' => 'Vous devez entrer l\'identifiant de l\'utilisateur',
                'id.integer' => 'Vous devez entrer l\'identifiant de l\'utilisateur avec un format correct',
            ]);
        }
        
        if ($vld->fails()) {
            $response['message'] = $vld->errors()->first(); 
            return Response::json($response);
        }
        
        $user = User::find($data['id']);
        if (!$user) {
            if ($language == 'ar') {
                $response['message'] = 'المستخدم غير موجود';
            } else {
                $response['message'] = 'utilisateur introuvable';
            }
            return Response::json($response);
        }
        
        $response['status'] = true;
        $response['data'] = $user;
        if ($language == 'ar') {
            $response['message'] = 'تم العثور على المستخدم بنجاح';
        } else {
            $response['message'] = 'utilisateur trouvé avec succès';
        }
        return Response::json($response);
    }
    
    public function GetAllUsers(Request $request)
    {
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
                
        $users = User::select('*')
        ->orderBy('id', 'desc')
        ->get();
        
        if(!$users->count()) {
            if($language == 'ar'){
                $message = 'لا يوجد مستخدمين.';
            }else{
                $message = 'Aucun utilisateur.';
            }
            $response['message'] = $message;
            return Response::json($response);
        }
        if($language == 'ar'){
            $message = 'تم جلب المستخدمين بنجاح.';
        }else{
            $message = 'Utilisateurs récupérés avec succès.';
        }
        
        $response['status'] = true;
        $response['message'] = $message;
        $response['data'] = $users;
        return Response::json($response);
    }
    
    public function GetAllDatatableServerSide (Request $request) {
        sleep(1);
        $response = array('status'=>false, 'message'=>null);
        
        $data = $request->input();
        
        $language = $data['language'];
        
        $columns = array( 
            0 => 'name',
            1 => 'email'
        );
        
        $totalData = User::count();
        
        $totalFiltered = $totalData;
        
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        
        if(empty($request->input('search.value')))
        {            
            $users = User::offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
        }
        else {
            $search = $request->input('search.value'); 
            
            $users =  User::where('name','LIKE',"%{$search}%")
            ->orWhere('email', 'LIKE',"%{$search}%")
            ->offset($start)
            ->limit($limit)
            ->orderBy($order,$dir)
            ->get();
            
            $totalFiltered = User::where('name','LIKE',"%{$search}%")
            ->orWhere('email', 'LIKE',"%{$search}%")
            ->count();
            
        }
        
        $draw = $request->input('draw');
        $data = array();
        
        if(!empty($users))
        {
            foreach ($users as $user)
            {
                $nestedData['name'] = $user->name;
                $nestedData['email'] = $user->email;
                $nestedData['action'] = '<button id="n_'.$user->id.'" type="button" class="btn btn-sm btn-primary" onclick="EditUserModal('.$user->id.')"><i class="fa fa-edit"></i></button>';
                $nestedData['action'] .= '<button type="button" class="btn btn-sm btn-danger" onclick="DeleteUser('.$user->id.')"><i class="fa fa-trash"></i></button>';
                $data[] = $nestedData;
            }
        }
        
        $json_data = array(
            "draw"            => intval($draw),
            "recordsTotal"    => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data"            => $data   
        );
        
        return Response::json($json_data);
    }
    
}