<?php
// Direct API bypass for notice/get/all - bypasses Laravel entirely
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    // Get database credentials from Laravel .env
    $envFile = '/home/alakhbarpressapp/public_html/last/application/.env';
    $envContent = file_get_contents($envFile);
    
    preg_match('/DB_HOST=(.*)/', $envContent, $hostMatch);
    preg_match('/DB_DATABASE=(.*)/', $envContent, $dbMatch);
    preg_match('/DB_USERNAME=(.*)/', $envContent, $userMatch);
    preg_match('/DB_PASSWORD=(.*)/', $envContent, $passMatch);
    
    $host = isset($hostMatch[1]) ? trim($hostMatch[1]) : 'localhost';
    $database = isset($dbMatch[1]) ? trim($dbMatch[1]) : '';
    $username = isset($userMatch[1]) ? trim($userMatch[1]) : '';
    $password = isset($passMatch[1]) ? trim($passMatch[1]) : '';
    
    // Connect to database
    $dsn = "mysql:host=$host;dbname=$database;charset=utf8mb4";
    $pdo = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    // Get request data
    $language = $_POST['language'] ?? $_GET['language'] ?? 'ar';
    $status = $_POST['status'] ?? $_GET['status'] ?? 'all';
    
    // Validate inputs
    if (!in_array($language, ['ar', 'fr'])) {
        $language = 'ar';
    }
    
    if (!in_array($status, ['active', 'inactive', 'deleted', 'all'])) {
        $status = 'all';
    }
    
    // Build query based on status
    if ($status === 'all') {
        $sql = "SELECT notices.*, categories.name_ara as category_name_ara, categories.name_fr as category_name_fr 
                FROM notices 
                JOIN categories ON categories.id = notices.category_id 
                ORDER BY notices.order DESC";
    } else {
        $sql = "SELECT notices.*, categories.name_ara as category_name_ara, categories.name_fr as category_name_fr 
                FROM notices 
                JOIN categories ON categories.id = notices.category_id 
                WHERE notices.status = :status
                ORDER BY notices.order ASC";
    }
    
    // Execute query
    $stmt = $pdo->prepare($sql);
    if ($status !== 'all') {
        $stmt->bindParam(':status', $status);
    }
    $stmt->execute();
    $notices = $stmt->fetchAll();
    
    // Format response like Laravel
    if (empty($notices)) {
        $message = ($language === 'ar') ? 'لا يوجد بيانات' : 'Aucune donnée trouvée';
        $response = [
            'status' => false,
            'message' => $message
        ];
    } else {
        $message = ($language === 'ar') ? 'تم الحصول على البيانات بنجاح' : 'Données obtenues avec succès';
        $response = [
            'status' => true,
            'message' => $message,
            'data' => $notices
        ];
    }
    
    echo json_encode($response);
    
} catch (Exception $e) {
    $response = [
        'status' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ];
    echo json_encode($response);
}
?>
